/* ==================================================== ======== ======= *
 *
 *  uborder.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uborder_hh
#define	_uborder_hh
//pragma ident	"@(#)uborder.hh		ubit:b1.11.5"
#include <uprop.hh>

UBorder& uborder(const UBorder&);
UBorder& uborder(const UMargin&, int decoration = 0);
UBorder& uborder(UArgs = UArgs::none);

/* ==================================================== ======== ======= */

class UBorder : public UProp {
public:
  static  const UClass  uclass;
  virtual const UClass* getClass() const {return &uclass;}

  static const int		// decorations
    NONE, ACTIVE_SHADOW_IN, ACTIVE_SHADOW_OUT, 
    SHADOW_IN, SHADOW_OUT, ETCHED_IN, ETCHED_OUT;

  static UBorder		// predefined borders
    none, activeShadowIn, activeShadowOut, 
    shadowIn, shadowOut, etchedIn, etchedOut;

  UBorder(const UBorder& = UBorder::none, u_modes = 0);
  UBorder(const UMargin&, int decoration = 0, u_modes = 0);
  UBorder(UArgs = UArgs::none);

  void set(const UBorder&, u_bool update = true);
  void setDecoration(int decoration);
  void setMargin(const UMargin&);
  void setColor(const UColor&);
  void setBgcolor(const UColor&);

  int getDecoration()         {return decoration;}
  const UMargin& getMargin()  {return margin;}
  const UColor*  getColor()   {return color;}
  const UColor*  getBgcolor() {return bgcolor;}

  // Object intialization
  virtual void init(ULink *selflink, ULink *parlink, UView *parview);

  // Updates graphics
  virtual void update();


  // === Package Internal API ===============================================

  virtual void putProp(UContext*, class UCtrl*);

  virtual u_bool doLayout(UView*, UContext &parp, UMargin &m);
  virtual u_bool doElemLayout(UView*, UContext &parp, UMargin &m);

  virtual void doUpdate(class UUpdateImpl&, class UWinGraph&, 
			UContext &parp, const URegion &r);
  virtual void doElemUpdate(class UUpdateImpl&, class UWinGraph&, 
			    UContext &parp, const URegion &r);
  virtual void doDecorUpdate(class UUpdateImpl&, class UWinGraph&, 
			     UContext &parp, const URegion &r);

  //virtual void getSize(UView*, UContext*, UMargin*) const;
  //virtual void paint(UWinGraph&, UContext*, const URegion &r, 
  //		     UView*, UMargin*) const;

protected:
  int decoration;
  UMargin margin;
  mutable const class UColor *color, *bgcolor;
  UGroup *elems;
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
