/* ==================================================== ======== ======= *
 *
 *  uboxImpl.hh
 *  Ubit Project [Elc][beta1][2001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _uboxImpl_hh
#define	_uboxImpl_hh
//pragma ident	"@(#)uboxImpl.hh	ubit:b1.11.0"

class UBoxLink : public ULink {
  friend class UGroup;
  friend class UBox;
  friend class UWin;
public:
  //protected:
  //class UViewStyle *viewStyle;
  UView **views;
  short viewCount; //deletedCount;

public:
  UBoxLink(class UBox*);
  // NOTE importante: ~UBoxLink ne detache PAS les liens !
  // normalement, c'est la fonction 'unlinkFromParent' appelee 
  // par 'remove' qui fait cela. 
  // Par contre ~UBoxLink() detruit les Views de ce lien.
  virtual ~UBoxLink();
 
  // returns the View that is INCLUDED in a given Parent View
  virtual UView* getView(UView* parent_view);
  virtual UView* getViewSize(UView* parent_view, u_dim *w, u_dim *h);

  // returns the View array for this BoxLink
  // !!CAUTION: certain views may have been deleted and be null in the 
  // view array ==> don't forget to check that view_array[k] != null

  int getViewCount() {return viewCount;}
  UView** getViews() {return views;}
  UView*  getView(int pos) {
    if (!views || pos >= viewCount) return null;
    else return views[pos];
  }
  void deleteRelatedViews(UView *parview);
};


class UViewIndex {
  friend class UBox;
protected:
  ULinkLink *ll;
  int       vpos;
  UViewIndex(ULinkLink *_ll) {ll = _ll; vpos = 0;}
public:
  UViewIndex& operator++();
  UViewIndex  operator++(int);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */
