/* ==================================================== ======== ======= *
 *
 *  umenuImpl.hh
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= */

#ifndef _umenuImpl_hh
#define	_umenuImpl_hh
//pragma ident	"@(#)umenuImpl.hh	ubit2000.12.3"

class UMenuCtrl {
  friend class UMenu;
  friend class UMenubar;
protected:
  class UAppli *appli;
  // stack of menus that are currently being grabbed
  // (the size of this stack is CASCADED_MENU_MAX_COUNT+1)
  UGroup **menuGrabStack; 
  int menuGrabCount;
  u_bool autoOpenMenus, activeMenuOpener;
  UGroup *lastOpenedMenu;

public:
  // Max number of cascaded Menus
  static const int CASCADED_MENU_MAX_COUNT;

  UMenuCtrl(class UAppli*);

  // is a menu currently grabbed ?
  u_bool currentGrab();
  // is 'this' menu currently grabbed ?
  u_bool isGrabbed(UGroup *menu);
  void registerGrabbedMenu(UGroup *menu);
  void closeAllGrabbedMenus(u_bool stop_auto_open_mode);
  void closeGrabbedMenusFrom(UGroup *menu, u_bool including_this_menu);
};


#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */

