/* ==================================================== ======== ======= *
 *
 *  utable.hh
 *  Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:01] ======= *
 * ==================================================== ======== ======= */

#ifndef _utable_hh
#define	_utable_hh
//pragma ident	"@(#)utable.hh	ubit:b1.11.6"
#include <uflow.hh>

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */
// UTable = UBox with UTableView renderer

class UTable: public UBox {
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  UTable(UArgs = UArgs::none);
};

UTable& utable(UArgs = UArgs::none);


/* ==================================================== ======== ======= */
// Table Row (MUST be un a UTable)

class UTrow: public UBox {
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  UTrow(UArgs = UArgs::none);
};

UTrow& utrow(UArgs = UArgs::none);

/* ==================================================== ======== ======= */
// Table Cell (MUST be in a UTrow)

class UTcell: public UFlowbox {
protected:
  short colspan, rowspan;
public:
  static const UClass uclass;
  static UStyle *style;

  virtual const UClass* getClass() const {return &uclass;}
  virtual const UStyle* getStyle(const UBox *parent);

  UTcell(UArgs = UArgs::none);
  UTcell(short colspan, UArgs = UArgs::none);
  UTcell(short colspan, short rowspan, UArgs = UArgs::none);

  void  setColspan(short);
  void  setRowspan(short);
  short getColspan() {return colspan;}
  short getRowspan() {return rowspan;}
};

UTcell& utcell(UArgs = UArgs::none);
UTcell& utcell(short colspan, UArgs = UArgs::none);
UTcell& utcell(short colspan, short rowspan, UArgs = UArgs::none);

/* ==================================================== [Elc:01] ======= */
/* ==================================================== ======== ======= */

class UTableView: public UView {
public:
  static  UViewStyle style;  // renderer
  virtual UViewStyle* getViewStyle() {return &style;}

  // "static" constructor used by UViewStyle to make a new view
  static UView* makeView(UBoxLink*, UView* parview, UWinGraph*);
  UTableView(UBoxLink*, UView* parview, UWinGraph*);
  virtual ~UTableView();

  virtual u_bool doLayout(UContext&, class UViewLayout &vl);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */

