/* ==================================================== ======== ======= *
 *
 *  uuprop.cc
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuprop.cc	ubit001.15"

#include <udefs.hh>
#include <ubrick.hh>
#include <uprop.hh>
#include <ucall.hh>
#include <uctrl.hh>
#include <ubox.hh>
#include <uevent.hh>
#include <uselect.hh>

#include <ucall.hh>
#include <uobs.hh>

const UClass URadioSelect::uclass("URadioSelect");

URadioSelect& uradioSelect(int ix) {
  return *(new URadioSelect(ix));
}

/* ==================================================== ======== ======= */


URadioSelect::URadioSelect(int ix, u_modes m) : UProp(m) {
  index = ix;
  card = 0;
  select_call = &ucall(this, &URadioSelect::selectCB, UOn::select);
  unselect_call = &ucall(this, &URadioSelect::selectCB, UOn::unselect);
  // initalisation faite dans addTo
}

void URadioSelect::addingTo(ULink *selflink,  UGroup *parent) {
  UProp::addingTo(selflink, parent);

  // ajouter handlers au box parent
  parent->add(select_call);
  // necessaire sinon un 2e clic sur un bouton selectionne
  // le de-selectionne
  parent->add(unselect_call);

  // initialiser le parent (risque que SElecetd soit apres !!!)
  if (card == index) {
    if (!parent->isSelected()) {
      parent->setCmodes(UMode::SELECTED, true);
      parent->update(UUpdate::paint);
    }
  }
  else { // k != index
    if (parent->isSelected()) {
      parent->setCmodes(UMode::SELECTED, false);
      parent->update(UUpdate::paint);
    }
  }
  card++;
}

/* ==================================================== ======== ======= */
//NB: removingFrom() requires a destructor to be defined
//
void URadioSelect::removingFrom(ULink *selflink, UGroup *parent) {
  // enlever les callbacks
  if (parent) {
    // false -> ne PAS detruire les ucall (qui sont partages!)
    parent->remove(select_call, false);
    parent->remove(unselect_call, false);
  }
  UProp::removingFrom(selflink, parent);
}

/* ==================================================== ======== ======= */

void URadioSelect::update() {
  parents.updateParents(UUpdate::paint);
}

void URadioSelect::putProp(UContext *props, UCtrl *state) {
}

// calls UOn::change then UOn::action callbacks when selection is changed
void URadioSelect::changed(u_bool update_now) {
  if (update_now) update();
  if (cache) {
    UEvent e(UEvent::change, null, NULL);
    e.setPropSource(this);
    fire(e, UOn::change);
    fire(e, UOn::action);
  }
}


/* ==================================================== ======== ======= */

void URadioSelect::set(int on_index) {
  setIndex(on_index);
}

void URadioSelect::setIndex(int on_index) {
  index = on_index;
  int k = 0;

  for (ULinkLink *l = parents.first(); l; l = l->next(), k++) {
    UGroup *obj = l->link()->parent();
    if (obj) { 
      if (k == index) {
	if (!obj->isSelected()) {
	  obj->setCmodes(UMode::SELECTED, true);
	  obj->update(UUpdate::paint);
	}
      }
      else { // k != index
	if (obj->isSelected()) {
	  obj->setCmodes(UMode::SELECTED, false);
	  obj->update(UUpdate::paint);
	}
      }
    }
  }

  changed(false);     // update();  deja fait objet par objet
}

/* ==================================================== ======== ======= */

void URadioSelect::set(UGroup *selection) {
  setSelected(selection);
}

void URadioSelect::setSelected(UGroup *selection) {
  index = -1; //!!
  int k = 0;

  for (ULinkLink *l = parents.first(); l; l = l->next(), k++) {
    UGroup *obj = l->link()->parent();
    if (obj) { 
      if (obj == selection) {
	index = k;
	if (!obj->isSelected()) {
	  obj->setCmodes(UMode::SELECTED, true);
	  obj->update(UUpdate::paint);
	}
      }
      else { // obj != selection
	if (obj->isSelected()) {
	  obj->setCmodes(UMode::SELECTED, false);
	  obj->update(UUpdate::paint);
	}
      }
    }
  }

  changed(false);     // update();  deja fait objet par objet
}

void URadioSelect::selectCB(UEvent *e) {
  //printf("source = %d\n", e->getSource());
  setSelected(e->getSource());
}

/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */
// !!ATT aux removes et add! 

int URadioSelect::getIndex() {
  //NB: index est mis a jour par selectCB
  return index;
}

UGroup* URadioSelect::getSelected() {
  int k = 0;
  for (ULinkLink *l = parents.first(); l; l = l->next(), k++) {
    //NB: au moins (UBox*) par construction
    UGroup *obj = l->link()->parent();
    if (k == index) return obj;
  }
  return null;			// pas trouve
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
