/* ==================================================== ======== ======= *
 *
 *  uuargs.cc : class for creating argument lists (additive notation).
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuargs.cc	ubit:3.4.0"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <ubrickImpl.hpp>
#include <uargs.hpp>
#include <ustr.hpp>


const UArgs UArgs::none;

UArgs::~UArgs() {
  //cerr << "~~args()" << endl;
  if (children->refcount > 1) children->refcount--;
  else if (children->refcount == 1) {
    //cerr << this << " del children\n";
    ULink* next = null;
    for (ULink *l = children->first(); l != null; l = next) {
      next = l->getNext();
      delete l;
    }
    delete children;
  }
}

UArgs::UArgs() {
  //cerr << "args()" <<endl;
  children = new UArgsChain();
  children->refcount = 1;
}

UArgs::UArgs(const UArgs& a) : children(a.children) {
  //cerr << "args(args)" <<endl;
  if (!children) {
    // cas UArgs::none pas encore initialise...
    children = new UArgsChain();
    children->refcount = 0;
  }
  children->refcount++;
}

UArgs::UArgs(const UArgsImpl& a) : children(a.children) {
  //cerr << "args(list)" <<endl;
  if (!children) {
    // cas UArgs::none pas encore initialise...
    children = new UArgsChain();
    children->refcount = 0;
  }
  children->refcount++;
}

UArgs::UArgs(const char *s) {
  //cerr << "args(s)" <<endl;
  children = new UArgsChain();
  children->refcount = 1;
  children->add((new UStr(s))->makeLink());
}

UArgs::UArgs(UBrick* child) {
  //cerr << "args(*b)" <<endl;
  if (!child) UError::error("UArgs::UArgs", UError::Null_arg_in_addlist);
  else {
    children = new UArgsChain();
    children->refcount = 1;
    children->add(child->makeLink());
  }
}

UArgs::UArgs(UBrick& child) {
  //cerr << "args(&b)" <<endl;
  children = new UArgsChain();
  children->refcount = 1;
  children->add(child.makeLink());
}

UArgs::UArgs(ULink& link) {
  if (!link.getChild()) 
    UError::error("UArgs::UArgs", UError::Null_arg_in_addlist);
  else { 
    children = new UArgsChain();
    children->refcount = 1;
    children->add(&link);
  }
}

UArgs::UArgs(ULink* link) {
  if (!link || !link->getChild()) 
    UError::error("UArgs::UArgs", UError::Null_arg_in_addlist);
  else {
    children = new UArgsChain();
    children->refcount = 1;
    children->add(link);
  }
}

UArgs& UArgs::operator+=(const UArgs& a0) {
  for (ULink *la0 = a0.children->first(); la0 != null; la0 = la0->getNext()) {
    ULink* link = la0->getChild()->makeLink();
    link->setCond(la0);      //ne pas paumer les conditions!
    children->add(link);
  }
  return *this;
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

UArgsImpl::~UArgsImpl() {
  //cerr << "~~list()" <<endl;
  if (children->refcount > 1) children->refcount--;
  else if (children->refcount == 1) {
    //cerr << this << " del children\n";
    ULink* next = null;
    for (ULink *l = children->first(); l != null; l = next) {
      next = l->getNext();
      delete l;
    }
    delete children;
  }
}

UArgsImpl::UArgsImpl() {
  //cerr << "list()" <<endl;
  children = new UArgsChain();
  children->refcount = 1;
}

UArgsImpl::UArgsImpl(const UArgsImpl& a) : children(a.children) {
  //cerr << "list(list)" <<endl;
  if (!children) {
    // cas UArgs::none pas encore initialise...
    children = new UArgsChain();
    children->refcount = 0;
  }
  children->refcount++;
}

UArgsImpl::UArgsImpl(const UArgs& a0) {
  //cerr << "list(args) COPIE" <<endl;
  children = new UArgsChain();
  children->refcount = 1;

  for (ULink *la0 = a0.children->first(); la0 != null; la0 = la0->getNext()) {
    ULink* link = la0->getChild()->makeLink();
    link->setCond(la0);      //ne pas paumer les conditions!
    children->add(link);
  }
}

UArgsImpl::UArgsImpl(const char *s) {
  //cerr << "list(s)" <<endl;
  children = new UArgsChain();
  children->refcount = 1;
  children->add((new UStr(s))->makeLink());
}

UArgsImpl::UArgsImpl(UBrick* child) {
  //cerr << "list(*b)" <<endl;
  if (!child) UError::error("UArgs::UArgs", UError::Null_arg_in_addlist);
  else {
    children = new UArgsChain();
    children->refcount = 1;
    children->add(child->makeLink());
  }
}

UArgsImpl::UArgsImpl(UBrick& child) {
  //cerr << "list(&b)" <<endl;
  children = new UArgsChain();
  children->refcount = 1;
  children->add(child.makeLink());
}

UArgsImpl::UArgsImpl(ULink& link) {
  if (!link.getChild()) 
    UError::error("UArgs::UArgs", UError::Null_arg_in_addlist);
  else { 
    children = new UArgsChain();
    children->refcount = 1;
    children->add(&link);
  }
}

UArgsImpl::UArgsImpl(ULink* link) {
  if (!link || !link->getChild()) 
    UError::error("UArgs::UArgs", UError::Null_arg_in_addlist);
  else {
    children = new UArgsChain();
    children->refcount = 1;
    children->add(link);
  }
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

// (args + addlist) -> recopie des links des children de addlist

const UArgsImpl& operator+(const UArgsImpl& a, const UArgs& a0) {
  //cerr << "list+args COPIE" << endl;
  for (ULink *la0 = a0.children->first(); la0 != null; la0 = la0->getNext()) {
    ULink* link = la0->getChild()->makeLink();
    link->setCond(la0);      //ne pas paumer les conditions!
    a.children->add(link);
  }
  return a;
}

const UArgsImpl& operator+(const UArgsImpl& a, const char *s) {
  //cerr << "list+s" << endl;
  UBrick *b = new UStr(s);
  a.children->add(b->makeLink());
  return a;
}

const UArgsImpl& operator+(const UArgsImpl& a, UBrick *b) {
  //cerr << "list+*b" << endl;
  if (!b) UError::error("operator+",  UError::Null_arg_in_addlist);
  else a.children->add(b->makeLink());
  return a;
}

const UArgsImpl& operator+(const UArgsImpl& a, UBrick &b) {
  //cerr << "list+&b" << endl;
  a.children->add(b.makeLink());
  return a;
}

const UArgsImpl& operator+(const UArgsImpl& a, ULink &link) {
  if (!link.getChild()) UError::error("operator+", UError::Null_arg_in_addlist);
  else a.children->add(&link);
  return a;
}

const UArgsImpl& operator+(const UArgsImpl& a, ULink *link) {
  if (!link || !link->getChild()) UError::error("operator+", UError::Null_arg_in_addlist);
  else a.children->add(link);
  return a;
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

ULink& operator/(const UCond& cond, UBrick& b) {
  ULink *link = b.makeLink();
  link->setCond(cond);
  return *link;
}

ULink& operator/(const UCond& cond, UBrick* b) {
  ULink *link;
  if (!b) {
    UError::error("operator/", UError::Null_argument);
    link = new ULink(null);
  }
  else {
    link = b->makeLink();
    link->setCond(cond);
  }
  return *link;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:02] ======= */

