/* ==================================================== ======== ======= *
 *
 *  uucontext.cpp
*  Ubit Project  [Elc:03]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uucontext.cpp	ubit:03.06.03"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <ubox.hpp>
#include <uwin.hpp>
#include <uview.hpp>
#include <ucolor.hpp>
#include <uevent.hpp>
#include <ustyle.hpp>
#include <ucontext.hpp>
#include <uappli.hpp>
#include <iostream>
using namespace std;

/* ==================================================== ======== ======= */

void ULocalProps::rescale(float xyscale) {
  vspacing = short(vspacing * xyscale);
  hspacing = short(hspacing * xyscale);
  padding.left   = short(padding.left  * xyscale);
  padding.right  = short(padding.right * xyscale);
  padding.top    = short(padding.top   * xyscale);
  padding.bottom = short(padding.bottom* xyscale);
}

void UContext::rescale() {
  local.rescale(xyscale);
}

/* ==================================================== ======== ======= */

UWinContext::~UWinContext() {
  if (flagdefs) free(flagdefs);
  flagdefs  = null;
  pflagdefs = null; 
}

// this method recopies the internal flag array
void UWinContext::copy(UWinContext &wc) {
  *this = wc;
  flagdefs = null;
  pflagdefs = &flagdefs;

  if (wc.flagdefs && wc.flagdefCount > 0) {
    flagdefs = (const UFlagdef**) malloc(wc.flagdefCount * sizeof(UFlagdef*));
    for (int k = 0; k < wc.flagdefCount; k++) 
      flagdefs[k] = wc.flagdefs[k];
  }
}

/* ==================================================== ======== ======= */
// creates the first layer of the context stack
// -- !Warning: 'win_view' must be a valid (not null) window view!

UWinContext::UWinContext(UView *win_view) : UContext() {
  flagdefs  = null;
  pflagdefs = &(flagdefs);
  flagdefCount = 0;
  
  winview = win_view;
  UBox *win = winview->getBox();   // getBox suffisant et necessaire
  obj = win;
  parent_box = null; //new 22sept03  (avant getstyle())

  //const UStyle& style = win->getStyle(null);
  //style.adapt(null);

  // new 22sept03
  const UStyle& style = win->getStyle(this);
  
  local = style.local;
  boxIsHFlex = boxIsVFlex = false;
  // nb: inherited => horizontal
  win->setBmodes(UMode::IS_VERTICAL, style.orient == UOrient::VERTICAL);

  cursor = style.cursor;

  color = style.getColor(obj); 
  if (!color) color = &UColor::black;

  bgcolor = style.getBgcolor(obj);  
  if (!bgcolor) bgcolor = &UBgcolor::none;

  lscale  = UAppli::getDefaults().app_lscale;  //NB: lscale = LOGICAL scale
  xyscale = UAppli::getDefaults().app_xyscale;  // set b y UDisp::UDisp
    
  // NB: UFont::standard imposes lsize = DEFAULT_LSIZE
  fontdesc.set(UFont::standard);

  // c'est un ajout de caracteristqiues: n'ecrase pas forcement tous les champs
  if (style.font) fontdesc.merge(*style.font, lscale);
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

UContext::UContext(UGroup *grp, UView *view, const UContext &parp) {
  obj       = grp;
  parent_box = view->getBoxParent(); //new 22sept03 (avant getstyle())
  winview   = parp.winview;
  pflagdefs = parp.pflagdefs;
  flagdefCount = parp.flagdefCount;
 
  //!ATT: getBoxParent() returns null if parent is a Window
  //const UStyle& style = grp->getStyle(view->getBoxParent());
  //style.adapt(&parp); // att: parp peut etre le context d'un UGroup !

  // new 22sept03
  const UStyle& style = grp->getStyle(this);

  // static props (must be done before retrieving states)
  // [a cause de width et height qui peuvent etre modifiee]
  local = style.local;
  
  // inherited dynamic props 
  lscale     = parp.lscale;	//NB: lscale = LOGICAL scale
  xyscale    = parp.xyscale;
  boxIsVFlex = (parp.local.valign == UValign::FLEX);
  boxIsHFlex = (parp.local.halign == UHalign::FLEX);

  if (style.orient == UOrient::INHERIT) {
    obj->setBmodes(UMode::IS_VERTICAL, parp.obj->isBmode(UMode::IS_VERTICAL));
    //cerr << "INHERIT isv= " << obj->isBmode(UMode::IS_VERTICAL) << endl;
  }
  else {
   obj->setBmodes(UMode::IS_VERTICAL, style.orient == UOrient::VERTICAL);
   //cerr << "context " << obj->cname() << " isv=" << (style.orient == UOrient::VERTICAL) << endl;
  }

  cursor = (style.cursor ? style.cursor : parp.cursor);

  color = style.getColor(obj);
  if (color == &UColor::inherit) color = parp.color;
  if (!color) color = &UColor::black;    // securite

  bgcolor = style.getBgcolor(obj);
  if (bgcolor == &UBgcolor::inherit) bgcolor = parp.bgcolor;
  if (!bgcolor) bgcolor = &UBgcolor::none;   // securite
  
  // FONTS:
  // -1- les fontes s'AJOUTENT et c'est pourquoi il faut toujours
  //     recopier parp->fontdesc qunad ca existe (les autres champs
  //     pouvant etre modifies ensuite)
  // -2- on ne change pas 'lscale' car deja fait au niveau du parent
  // (puisque dans ce cas [voir lignes preced.] scale = celui du parent)
  fontdesc = parp.fontdesc;

  // c'est un ajout de caracteristiques, pas forcement une recopie totale
  // ==> utiliser merge()
  if (style.font != &UFont::inherit) fontdesc.merge(*style.font, lscale);  
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UContext::addFlagdef(const UFlagdef* _flagdef) {
  if (!pflagdefs) {
    UError::error("internal@UContext::addFlag", "Null flag vector");
    return;
  }

  if (*pflagdefs)
    *pflagdefs = (const UFlagdef**)realloc(*pflagdefs,
                                           (flagdefCount+1) * sizeof(UFlagdef*));
  else *pflagdefs = (const UFlagdef**)malloc(sizeof(UFlagdef*));

  (*pflagdefs)[flagdefCount] = _flagdef;
  (flagdefCount)++;
}

/* ==================================================== ======== ======= */

const UFlagdef* UContext::getFlagdef(const UFlag& _flag) const {
  return getFlagdef(&_flag);
}

const UFlagdef* UContext::getFlagdef(const UFlag* _flag) const {
  if (!pflagdefs || !*pflagdefs) return null;

  for (int k = 0; k < flagdefCount; k++)
    if ((*pflagdefs)[k]->getFlag() == _flag) return (*pflagdefs)[k];

  return null;  // not found
}

/* ==================================================== ======== ======= */

const UPropdef* UContext::getPropdef(const UFlag& _flag) const {
  return getPropdef(&_flag);
}
  
const UPropdef* UContext::getPropdef(const UFlag* _flag) const {
  if (!pflagdefs || !*pflagdefs) return null;

  const UPropdef* last_pdef = null;
  //att: comme il peut y avoir plusieurs propdef empilees il faut
  //toujours prendre la derniere

  for (int k = 0; k < flagdefCount; k++) {
    const UPropdef* pdef = null;
    if ((*pflagdefs)[k]->getFlag() == _flag
        && (pdef = dynamic_cast<const UPropdef*>((*pflagdefs)[k]))
        ) {
      last_pdef = pdef;
    }
  }

  return last_pdef;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */


