/* ==================================================== ======== ======= *
 *
 *  uuerror.cpp
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uuerror.cc	ubit:03.06.04"
#include <stdio.h>
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <uerror.hpp>
#include <ucall.hpp>
#include <ustr.hpp>
using namespace std;


const char*UError::No_more_memory        = "No more memory";

const char* UError::Null_argument        = "Null argument";

const char* UError::Null_or_invalid_argument = "Null or invalid argument";

const char* UError::Null_arg_in_addlist  = "Null argument in addlist";

const char* UError::Warning_out_of_range = "[warning] Index is out of range:";

const char* UError::Child_not_found      = "Child not found: child class:";

const char* UError::Too_many_elements    = "Too_many_elements:";

const char* UError::Unexpected_type      = "Unexpected_type:";

const char* UError::Not_yet_implemented  = "Not_yet_implemented";

const char* UError::Null_display
= "Can't display GUI: null X display or null screen";

const char* UError::Unrealized_window
= "Unrealized Window:\n - check if this window has a parent and if this parent is realized";

const char* UError::Cant_realize_window
= "Can't realize Window:\n - check if this window has a parent and if this parent is realized\n - (valid parents may be any UBox or UWin objects or the UAppli)";

const char* UError::Cant_realize_softwin
= "Wrong type: can't realize soft window";

const char* UError::Cant_create_window = "Can't create X Window";

const char* UError::Cant_open_display	 = "Can't open display:";

const char* UError::Invalid_screen	 = "Invalid Screen";

const char* UError::Null_external_window
= "Null external X Window given as an argument";

const char* UError::Cant_realize_wingraph
= "!Fatal Error: could not realize UWinGraph";

const char* UError::Unbalanced_request
= "unbalanced UWinGraph::begin()/end() request";

const char* UError::Cant_retreive_font
= "Can't retreive Font";

const char* UError::Invalid_font_size
= "Font size is too large";

const char* UError::Null_colormap
= "Could not create Colormap";

const char* UError::Full_colormap
= "The colormap is full: can't allocate color:";  // ONCE true;

const char* UError::Unknown_color
= "Can't allocate color null or unknown color name:";

const char* UError::Null_width_or_height
= "null width or null height";

const char* UError::Incompatible_depths
= "the source and destination have incompatible depths";

const char* UError::Unrealized_image
= "Unrealized_image";

const char* UError::Blending_requires_TrueColor
= "alpha blending requires TrueColor Visual\n - (call UAppli::setTrueColors() after creating the UAppli)"; // ONCE true;
		  
const char* UError::Cant_retreive_context
= "Cant_retreive_context";

const char* UError::Cant_retreive_style
= "Cant_retreive_style";

const char* UError::Cant_locate_source
= "NULL window view: can't locateSource";

const char* UError::Should_not_be_realized
= "this method must be called before the object is realized \n(i.e. before adding it to a realized parent)";

const char* UError::Wrong_table_child
= "Wrong object type: UTable(s) can only contain UTRow(s) class:";

const char* UError::Wrong_row_child
= "Wrong object type:\nTable Rows should contain UTcell, UBox or UGroup objects (and subclasses):";


/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UError::error(const char* id, const char *errmess) {  
  process_error(id, errmess, false, (const char*)0);
}

void UError::error(const char* id, const char *errmess, long arg) {
  char s_arg[10];
  sprintf(s_arg, "%ld", arg);
  process_error(id, errmess, true, s_arg);
}

void UError::error(const char* id, const char *errmess, const char* arg) {  
  process_error(id, errmess, true, arg);
}

void UError::error(const char* id, const char *errmess, const UStr& arg) {  
  process_error(id, errmess, true, arg.chars());
}

void UError::error(const char* id, const char *errmess, const string& arg) {  
  process_error(id, errmess, true, arg.c_str());
}

/* ==================================================== ======== ======= */

void UError::process_error(const char* id, const char *errmess,
			   bool has_arg, const char*arg) {

  cerr << "UError: " << id << endl;

  if (errmess) {
    cerr << "-- " << (errmess ? errmess : "???");

    if (has_arg) cerr << " " << (arg ? arg : "");

    cerr << endl << endl;
  }

  if (strstr(id, "fatal@")) {
    throw new UError(id, errmess, arg);
  }
}

/* ==================================================== ======== ======= */

UError::UError(const char* _id, const char* _msg, const char* _arg) :
  id(_id),
  msg(_msg),
  arg(_arg ? CStr::strdup(_arg) : null)
{}

UError::~UError() {
  free(arg);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
