/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qaction.h>
#include <qtoolbar.h>
#include <qlineedit.h>
#include <qtextbrowser.h>
//-----------------------------------------------------------------------------
#include "helpwindow.h"
extern QString pathHelp;
//-----------------------------------------------------------------------------
HelpWindow::HelpWindow(QWidget *parent) : QMainWindow(parent)
{
	setWindowTitle(tr("UDAV - Help"));
	QAction *a;
	QToolBar *b;
	QLineEdit *e;
	hlp = new QTextBrowser(this);

	b = new QToolBar(tr("Help Operations"), this);
	addToolBar(Qt::TopToolBarArea, b);
	a = new QAction(QPixmap(":/xpm/go-previous.png"), tr("Backward"), this);
	connect(a, SIGNAL(activated()), hlp, SLOT(backward()));
	b->addAction(a);
	e = new QLineEdit(this);	b->addWidget(e);
	connect(e, SIGNAL(textChanged(const QString &)), this, SLOT(showHelp(const QString &)));
	a = new QAction(QPixmap(":/xpm/go-next.png"), tr("Forward"), this);
	connect(a, SIGNAL(activated()), hlp, SLOT(forward()));
	b->addAction(a);

	hlp->setSource(pathHelp+tr("script_mgl_eng.html"));
	setCentralWidget(hlp);
	resize(500, 600);
}
//-----------------------------------------------------------------------------
HelpWindow::~HelpWindow()
{
}
//-----------------------------------------------------------------------------
void HelpWindow::showExamples()
{
	hlp->setSource(pathHelp+tr("example_mgl_eng.html"));
	setWindowTitle("UDAV examples");
	show();
}
//-----------------------------------------------------------------------------
void HelpWindow::showHelp(const QString &cmd)
{
	if(cmd.isEmpty())
		hlp->setSource(pathHelp+tr("script_mgl_eng.html"));
	else
		hlp->setSource(pathHelp+tr("script_mgl_eng.html")+"#"+cmd);
	setWindowTitle("UDAV help");
	show();	raise();
}
//-----------------------------------------------------------------------------
