/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

// collect result of GOptionContext to UgDataset

#ifndef UG_OPTION_H
#define UG_OPTION_H

#include <glib.h>
#include <ug_dataset.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct		UgOption_			UgOption;

typedef gboolean	(*UgGetDatasetFunc)	(const UgOption* option, UgDataset* dataset);

extern	const		UgOption*			UgOptionMain;

struct UgOption_
{
	// This structure base on UgClass
	const gchar*		name;
	gpointer			reserve;	// reserve for GModule-related code

	GOptionEntry*		option_entry;
	gpointer			option_data;
	guint				option_data_size;	// size of option_data

	UgInitFunc			init;				// init option_data
	UgGetDatasetFunc	get_dataset;
};

// These functions can use with g_list_foreach().
void ug_option_set_group   (const UgOption* option, GOptionGroup* group);
void ug_option_get_dataset (const UgOption* option, UgDataset*  dataset);
void ug_option_init_data   (const UgOption* option);


// ---------------------------------------------------------------------------
// UgOptionMainData
//
typedef struct	UgOptionMainData_			UgOptionMainData;

struct UgOptionMainData_
{
	// option_entry->arg_data place below
	gboolean	quiet;
	gint		category_index;
	gchar*		input_file;

	gchar*		folder;
	gchar*		filename;

	gchar*		user;
	gchar*		password;

	gint		proxy_type;
	gchar*		proxy_host;
	guint		proxy_port;
	gchar*		proxy_user;
	gchar*		proxy_password;

	gchar*		http_user;
	gchar*		http_password;
	gchar*		http_referer;
	gchar*		http_cookie_data;
	gchar*		http_cookie_file;
	gchar*		http_post_data;
	gchar*		http_post_file;

	gchar*		ftp_user;
	gchar*		ftp_password;
};


#ifdef __cplusplus
}
#endif

#endif  // End of UG_OPTION_H

