/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <string.h>

#include <glib.h>
#include <gmodule.h>

#include <ug_class.h>
#include <ug_data.h>
#include <ug_plugin.h>
#include <ug_option.h>


static GHashTable*	class_hash_table	= NULL;

void	ug_class_register	(const gchar* name, const gchar* class_type, gpointer ug_class)
{
	gchar*	string;

	if (class_hash_table == NULL)
		class_hash_table = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);

	string = g_strconcat (class_type, name, NULL);
	g_hash_table_insert (class_hash_table, string, ug_class);
//	g_free (string);	// string will be freed by GHashTable in this case.
}

void	ug_class_unregister	(const gchar* name, const gchar* class_type)
{
	gchar*	string;

	if (class_hash_table == NULL)
		return;

	string = g_strconcat (class_type, name, NULL);
	g_hash_table_remove (class_hash_table, string);
	g_free (string);
}

gpointer	ug_class_find	(const gchar* name, const gchar* class_type)
{
	gchar*		string;
	gpointer	result;

	if (class_hash_table == NULL)
		return NULL;

	string = g_strconcat (class_type, name, NULL);
	result = g_hash_table_lookup (class_hash_table, string);
	g_free (string);

	return result;
}


// ---------------------------------------------------------------------------
// register from file & folder
/*

#ifdef _WIN32
#define FILE_EXT        ".dll"
#define FILE_EXT_LEN    4
#else
#define FILE_EXT        ".so"
#define FILE_EXT_LEN    3
#endif

gboolean	ug_class_register_file	(const gchar* file_path)
{
	UgDataClass*	data_class;
	UgPluginClass*	plugin_class;
	UgOption*		option;
	GModule*		module;
	UgModuleInfo*	module_info;
	gboolean		result = FALSE;

	module = g_module_open (file_path, G_MODULE_BIND_LAZY);
	if (module == NULL) {
		g_message ("g_module_open() fail : %s.\n", g_module_error ());
		return FALSE;
	}

	if ( g_module_symbol (module, "ug_module_info", (gpointer)&module_info) ) {
		for (; obj_class; obj_class++)
			ug_class_register (obj_class);
		result = TRUE;
	}
//	g_module_close (module);

	return result;
}

guint	ug_class_register_folder	(const gchar* folder)
{
	const gchar*	filename;
	gchar*			full_path;
	guint			length;
	guint			count = 0;
	GDir*			dir;

	dir = g_dir_open (folder, 0, NULL);

	if (dir == NULL) {
		g_message ("ug_class_register_folder () : %s open fail\n", folder);
		return 0;
	}

	for (;;) {
		filename = g_dir_read_name (dir);
		if (filename == NULL)
			break;

		length = strlen (filename);
		if (length < FILE_EXT_LEN)
			continue;
		if (strncmp (filename +length -FILE_EXT_LEN, FILE_EXT, FILE_EXT_LEN) != 0)
			continue;

		full_path = g_build_filename (folder, filename, NULL);
		g_message ("ug_class_register_folder () : load %s\n", full_path);
		if (ug_class_register_file (full_path))
			count++;
	}

	return count;
}

*/
