#include <stdlib.h>		// exit(), EXIT_SUCCESS, EXIT_FAILURE

#ifdef _WIN32
#include <io.h>
#include <windows.h>
#include <winsock.h>
#endif  // _WIN32

// uget
#include <ug_dataset.h>
#include <ug_message.h>
#include <ug_option.h>
#include <ug_utils.h>
#include <ug_data_download.h>
#include <ug_plugin_curl.h>


static void  dump_progress (UgProgress* progress)
{
#ifdef _WIN32
	printf  ("complete  size : %I64d byte\n", progress->complete);
#else
	g_print ("complete  size : %lld byte\n", (long long int) progress->complete);
#endif

#ifdef _WIN32
	printf  ("total size     : %I64d byte\n", progress->total);
#else
	g_print ("total size     : %lld byte\n", (long long int) progress->total);
#endif
	g_print ("current speed  : %.2f byte/sec\n", progress->current_speed);
	g_print ("average speed  : %.2f byte/sec\n", progress->average_speed);
	g_print ("percent        : %.2f%%\n", progress->percent);
	g_print ("consumed time  : %.2f sec\n", progress->consume_time);
	g_print ("remain time    : %.2f sec\n", progress->remain_time);
//	g_print ("retry_count    : %d\n\n", progress->retry_count);
}

void message_callback (gpointer plugin, const UgMessage* msg, gpointer callback_data)
{
	UgProgress*	progress;

	switch (msg->type) {
	case UG_MESSAGE_STATE:
		g_print ("--- Message State : State changed to %d\n", msg->data.v_int);
		break;

	case UG_MESSAGE_PROGRESS:
		g_print ("--- Message Progress :\n");
		progress = ug_data_new (UgProgressClass);
		if (ug_plugin_get (plugin, UG_DATA_TYPE_INSTANCE, progress) == UG_RESULT_OK)
			dump_progress (progress);
		ug_data_free (progress);
		break;

	case UG_MESSAGE_ERROR:
		g_print ("--- Message Error %d: %s\n", msg->code, msg->string);
		break;

	case UG_MESSAGE_WARNING:
		g_print ("--- Message Warning %d: %s\n", msg->code, msg->string);
		break;

	case UG_MESSAGE_INFO:
		g_print ("--- Message Info %d: %s\n", msg->code, msg->string);
		break;

	case UG_MESSAGE_DATA:
		switch (msg->code) {
		case UG_MESSAGE_DATA_FILE_CHANGED:
			g_print ("--- Message Data : File changed to %s\n", msg->data.v_string);
			break;
		// HTTP message
		case UG_MESSAGE_DATA_HTTP_LOCATION:
			g_print ("--- Message Data : HTTP Location: %s\n", msg->data.v_string);
			break;
		case UG_MESSAGE_DATA_HTTP_CONTENT_LOCATION:
			g_print ("--- Message Data : HTTP Content-Location: %s\n", msg->data.v_string);
			break;
		case UG_MESSAGE_DATA_HTTP_CONTENT_DISPOSITION:
			g_print ("--- Message Data : HTTP Content-disposition: %s\n", msg->data.v_string);
			break;
		default:
			break;
		}
		break;

	default:
		break;
	}
}


int main (int argc, char* argv[])
{
	UgDataset*		data;
	UgDataCommon*	common;
	UgPlugin*		plugin;

	GOptionContext*	context;
	GOptionGroup*	group;
	GError*			error = NULL;

#ifdef _WIN32
	//	curl_global_init() will do this
//	WSADATA WSAData;
//
//	WSAStartup (MAKEWORD (2, 2), &WSAData);
#endif

	// glib
	if (g_thread_supported () == FALSE)
		g_thread_init (NULL);
//	if (g_module_supported () == FALSE)
//		return FALSE;

	// uget library
	ug_global_init ();

	context = g_option_context_new ("[URL]");
	group	= g_option_group_new (NULL, NULL, NULL, NULL, NULL);
	ug_option_set_group (UgOptionMain, group);
	g_option_context_set_main_group (context, group);
//	g_option_context_add_group (context, gtk_get_option_group (TRUE));
	if (g_option_context_parse (context, &argc, &argv, &error) == FALSE) {
		g_print ("Option parsing failed : %s\n", error->message);
		exit (EXIT_FAILURE);		// EXIT_FAILURE == 1
	}

	if (argc == 1) {
		g_print ("%s", g_option_context_get_help (context, TRUE, NULL));
		exit (EXIT_FAILURE);		// EXIT_FAILURE == 1
	}
	data = ug_data_new (UgDatasetClass);
	ug_option_get_dataset (UgOptionMain, data);
	common = ug_dataset_realloc (data, UgDataCommonClass, 0);
	common->url = g_strdup (argv[1]);

//	plugin = ug_plugin_new_by_name ("curl", data);
	plugin = ug_plugin_new (UgPluginCurlClass, data);

	ug_plugin_set_state (plugin, UG_STATE_RUNNING);
	while (ug_plugin_dispatch (plugin, message_callback, NULL))
		ug_plugin_delay (plugin, 1000);

	ug_plugin_unref (plugin);

	ug_global_finalize ();

#ifdef _WIN32
//	WSACleanup ();
#endif

	return EXIT_SUCCESS;		// EXIT_SUCCESS == 0
}

