/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_DATA_APP_H
#define UG_DATA_APP_H

#include <ug_data.h>
#include <ug_data_download.h>
#include <ug_plugin.h>
#include <ug_message.h>
#include <ug_category.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct	UgDataApp_		UgDataApp;

extern	const	UgDataClass*	UgDataAppClass;

// ---------------------------------------------------------------------------
// UgDataApp : Uget application related data.
//
//	UgData
//	|
//	+- UgDataApp
//
// UgMarkup input  : ug_data_in_markup()
// UgMarkup output : ug_data_to_markup()
struct UgDataApp_
{
	UG_DATA_MEMBERS (UgDataApp);
//	const UgDataClass*	data_class;
//	UgDataApp*			next;
//	UgDataApp*			prev;

	// category in total list
	UgCategory*		total_list;
	GtkTreeIter		total_list_iter;

	// category in category tree
	UgCategory*		category;
	GtkTreeIter		category_iter;
	gchar*			category_name;	// free by ug_app_data_finalize()

	// for application display
	UgListIcon		list_icon;
	UgMessageType	message_type;
	gchar*			message;		// free by ug_app_data_finalize()

	// for application temporal data
	gpointer		pointer;
	gpointer		plugin;
	UgState			plugin_state;
};

// This function allocate a new UgDataset and set all download/category related data in it.
UgDataset*	ug_dataset_new_app ();


#ifdef __cplusplus
}
#endif

#endif  // End of UG_DATA_APP_H

