/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_LIST_VIEW_H
#define UG_LIST_VIEW_H

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef	enum	UgListIcon_			UgListIcon;

enum	UgListIcon_
{
	UG_LIST_ICON_FILE,
	UG_LIST_ICON_PAUSED,
	UG_LIST_ICON_RUNNING,
	UG_LIST_ICON_EXECUTE,
	UG_LIST_ICON_REFRESH,
	UG_LIST_ICON_COMPLETED,
	UG_LIST_ICON_RECYCLED,
	UG_LIST_ICON_CATEGORY,
	UG_LIST_ICON_FOLDER,
	UG_LIST_ICON_NETWORK,
	UG_LIST_ICON_INFO,
	UG_LIST_ICON_WARNING,
	UG_LIST_ICON_ERROR,
	UG_LIST_N_ICON
};

// GtkTreeViewColumn* column;
// column = gtk_tree_view_get_column (tree_view, UG_DOWNLOAD_COLUMN_NAME);
// gtk_tree_view_column_set_visible (column, TRUE);
enum UG_DOWNLOAD_COLUMN {
	UG_DOWNLOAD_COLUMN_NAME,
	UG_DOWNLOAD_COLUMN_COMPLETE,
	UG_DOWNLOAD_COLUMN_TOTAL,
	UG_DOWNLOAD_COLUMN_PERCENT,
	UG_DOWNLOAD_COLUMN_ELAPSED,    // consuming time
	UG_DOWNLOAD_COLUMN_LEFT,       // remaining time
	UG_DOWNLOAD_COLUMN_SPEED,
	UG_DOWNLOAD_COLUMN_RETRY,
	UG_DOWNLOAD_COLUMN_CATEGORY,   // category name
	UG_DOWNLOAD_COLUMN_URL,
	UG_DOWNLOAD_N_COLUMN
};

enum UG_CATEGORY_COLUMN {
	UG_CATEGORY_COLUMN_NAME,
	UG_CATEGORY_COLUMN_QUANTITY,
	UG_CATEGORY_N_COLUMN
};

enum UG_ITEM_VIEW_COLUMN {
	UG_ITEM_VIEW_COLUMN_TOGGLE,
	UG_ITEM_VIEW_COLUMN_NAME,
	UG_ITEM_VIEW_COLUMN_VALUE,
	UG_ITEM_VIEW_N_COLUMN
};


GtkTreeView*	ug_download_view_new (void);

GtkTreeView*	ug_category_view_new (void);

GtkTreeView*	ug_item_view_new (const gchar* name_title, const gchar* value_title);
void			ug_item_view_for_summary (GtkTreeView* item_view);
void			ug_item_view_for_selector (GtkTreeView* item_view);


#ifdef __cplusplus
}
#endif

#endif  // End of UG_LIST_VIEW_H

