/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_SELECTOR_H

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct	UgSelector_			UgSelector;

struct UgSelector_
{
	GtkWidget*		self;

	// GtkTreeView*		place in index 0, 2, 4, 6
	// GtkListStore*	place in index 1, 3, 5, 7
	GPtrArray*		page_array;

	GtkNotebook*	notebook;
	// <base href>
	GtkWidget*		href_label;
	GtkEntry*		href_entry;		// entry for hypertext reference
	GtkWidget*		href_separator;
	// mark button
	GtkWidget*		mark_all;
	GtkWidget*		mark_none;
	GtkWidget*		mark_by_filter;

	GtkWindow*		parent;		// container
	GtkDialog*		message_dialog;
	GtkDialog*		filter_dialog;
	GtkTreeView*	filter_host;
	GtkTreeView*	filter_ext;
};

void	ug_selector_init (UgSelector* selector, GtkWindow* container);
void	ug_selector_finalize (UgSelector* selector);

void		ug_selector_hide_href (UgSelector* selector);
gboolean	ug_selector_show_error (UgSelector* selector);
GtkListStore*	ug_selector_add_page (UgSelector* selector, const gchar* title);
GtkListStore*	ug_selector_get_store (UgSelector* selector, guint nth_page);
GList*			ug_selector_get_marked (UgSelector* selector);	// UgItem
// call g_list_free() to free list

#ifdef __cplusplus
}
#endif

#endif  // End of UG_SELECTOR_H

