/* ========================================================================== */
/* === UMF_report_vector ==================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

#include "umf_internal.h"

GLOBAL Int UMF_report_vector
(
    const char name [ ],
    Int n,
    const double X [ ],
    Int prl,
    Int user
)
{
    Int n2, i ;

    ASSERT (prl >= 3) ;

    if (user || prl >= 4)
    {
	PRINTF (("\n")) ;
	if (name)
	{
	    PRINTF (("%s: ", name)) ;
	}
	PRINTF (("real vector, n = "ID". ", n)) ;
    }

    if (user)
    {
	if (!X)
	{
	    PRINTF (("ERROR: real vector not present\n\n")) ;
	    return (UMFPACK_ERROR_argument_missing) ;
	}
	if (n < 0)
	{
	    PRINTF (("ERROR: length of real vector is < 0\n\n")) ;
	    return (UMFPACK_ERROR_n_nonpositive) ;
	}
    }

    if (user || prl >= 4)
    {
	PRINTF4 (("\n")) ;
    }

    if (prl == 4)
    {
	n2 = MIN (10, n) ;
	for (i = 0 ; i < n2 ; i++)
	{
	    PRINTF (("    "ID" : %g\n", INDEX (i), X [i])) ;
	}
	if (n2 < n)
	{
	    PRINTF (("    ...\n")) ;
	    PRINTF (("    "ID" : %g\n", INDEX (n-1), X [n-1])) ;
	}
    }
    else if (prl > 4)
    {
	/* print level 4 or more */
	for (i = 0 ; i < n ; i++)
	{
	    PRINTF (("    "ID" : %g\n", INDEX (i), X [i])) ;
	}
    }

    if (name)
    {
	PRINTF4 (("    %s: ", name)) ;
    }
    PRINTF4 (("real vector ")) ;
    if (user || prl >= 4)
    {
	PRINTF (("OK\n\n")) ;
    }
    return (UMFPACK_OK) ;
}

