/* ========================================================================== */
/* === UMFPACK_report_control =============================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Prints the control settings.  See umfpack_report_control.h
    for details.
*/

#include "umf_internal.h"

GLOBAL void UMFPACK_report_control
(
    const double Control [UMFPACK_CONTROL]
)
{
    Int prl ;
    double drow, dcol ;

    if (!Control)
    {
	/* default is no printing, so just return */
	return ;
    }
    prl = (Int) Control [UMFPACK_PRL] ;
    if (prl < 2)
    {
	return ;
    }

    PRINTF (("\n%s, Control:\n", UMFPACK_VERSION)) ;

    /* ---------------------------------------------------------------------- */
    /* run-time options */
    /* ---------------------------------------------------------------------- */

    /* This is a "run-time" option because both umfpack_* and umfpack_l_* are */
    /* compiled into the UMFPACK library. */
#if defined (DINT)
    PRINTF (("    Int (generic integer) is defined as: int\n")) ;
#else
    PRINTF (("    Int (generic integer) is defined as: long\n")) ;
#endif

    PRINTF (("    "ID": print level: "ID"\n", (Int) INDEX (UMFPACK_PRL), prl)) ;

    drow = Control [UMFPACK_DENSE_ROW] ;
    PRINTF (("    "ID": dense row parameter:    %g\n",
	(Int) INDEX (UMFPACK_DENSE_ROW), drow)) ;
    PRINTF ((
	"       (\"dense\" rows have    > max (16, (%g)*16*sqrt(n)) entries)\n",
	drow)) ;

    dcol = Control [UMFPACK_DENSE_COL] ;
    PRINTF (("    "ID": dense column parameter: %g\n",
	(Int) INDEX (UMFPACK_DENSE_COL), dcol)) ;
    PRINTF ((
	"       (\"dense\" columns have > max (16, (%g)*16*sqrt(n)) entries)\n",
	dcol)) ;

    PRINTF (("    "ID": pivot tolerance: %g\n",
	(Int) INDEX (UMFPACK_PIVOT_TOLERANCE),
	Control [UMFPACK_PIVOT_TOLERANCE])) ;

    PRINTF (("    "ID": block size for dense matrix kernels: "ID"\n",
	(Int) INDEX (UMFPACK_BLOCK_SIZE), (Int) Control [UMFPACK_BLOCK_SIZE])) ;

    PRINTF (("    "ID": relaxed amalgamation parameter:  %g\n",
	(Int) INDEX (UMFPACK_RELAXED_AMALGAMATION),
	Control [UMFPACK_RELAXED_AMALGAMATION])) ;

    PRINTF (("    "ID": initial allocation ratio: %g\n",
	(Int) INDEX (UMFPACK_ALLOC_INIT), Control [UMFPACK_ALLOC_INIT])) ;

    PRINTF (("    "ID": relaxed2 amalgamation parameter: %g\n",
	(Int) INDEX (UMFPACK_RELAXED2_AMALGAMATION),
	Control [UMFPACK_RELAXED2_AMALGAMATION])) ;

    PRINTF (("    "ID": relaxed3 amalgamation parameter: %g\n",
	(Int) INDEX (UMFPACK_RELAXED3_AMALGAMATION),
	Control [UMFPACK_RELAXED3_AMALGAMATION])) ;

    PRINTF (("    "ID": pivoting option: %g ",
	(Int) INDEX (UMFPACK_PIVOT_OPTION), Control [UMFPACK_PIVOT_OPTION])) ;

    if (Control [UMFPACK_PIVOT_OPTION] == UMFPACK_DEFAULT_PIVOT_OPTION)
    {
	PRINTF ((" (default unsymmetric pivoting)\n")) ;
    }
    else
    {
	PRINTF ((" (prefer symmetric pivots, if numerically acceptable)\n")) ;
    }

    PRINTF (("    "ID": max iterative refinement steps: "ID"\n\n",
	(Int) INDEX (UMFPACK_IRSTEP), (Int) Control [UMFPACK_IRSTEP])) ;

    /* ---------------------------------------------------------------------- */
    /* compile-time options */
    /* ---------------------------------------------------------------------- */

    PRINTF ((
	"    The following options can only be changed at compile-time:\n")) ;

#ifndef NBLAS
    PRINTF (("    "ID": compiled to use the BLAS\n",
	(Int) INDEX (UMFPACK_COMPILED_WITH_BLAS))) ;
#else
    PRINTF ((
	"    "ID": compiled without the BLAS.  Uses non-optimized C\n"
	"        equivalents for dgemm, dger, and dgemv.  You will not\n"
	"        get the best possible performance.\n",
	(Int) INDEX (UMFPACK_COMPILED_WITH_BLAS))) ;
#endif

#ifdef MATLAB_MEX_FILE
    PRINTF (("    "ID": compiled for Matlab"
    " (uses mxMalloc, mxFree, mxRealloc, and mexPrintf)\n",
	(Int) INDEX (UMFPACK_COMPILED_FOR_MATLAB))) ;
#else
#ifdef MATHWORKS
    PRINTF (("    "ID": compiled for Matlab, using internal utility routines\n"
    "        (uses utMalloc, utFree, utRealloc, and utPrintf)\n",
	(Int) INDEX (UMFPACK_COMPILED_FOR_MATLAB))) ;
#else
    PRINTF (("    "ID": compiled for ANSI C"
    " (uses malloc, free, realloc, and printf)\n",
	(Int) INDEX (UMFPACK_COMPILED_FOR_MATLAB))) ;
#endif
#endif

#ifdef GETRUSAGE
    PRINTF (("    "ID": CPU timer is getrusage.\n",
	(Int) INDEX (UMFPACK_COMPILED_WITH_GETRUSAGE))) ;
#else
    PRINTF (("    "ID": CPU timer is ANSI C clock (may wrap around).\n",
	(Int) INDEX (UMFPACK_COMPILED_WITH_GETRUSAGE))) ;
#endif

#ifndef NDEBUG
    PRINTF (("    "ID": compiled with debugging enabled\n"
    "        This will be exceedingly slow!  ",
	(Int) INDEX (UMFPACK_COMPILED_IN_DEBUG_MODE))) ;
#ifdef MATLAB_MEX_FILE
    PRINTF (("Uses mxAssert.\n")) ;
#else
#ifdef MATHWORKS
    PRINTF (("Uses ANSI C assert.\n")) ;
#else
    PRINTF (("Uses ANSI C assert.\n")) ;
#endif
#endif
#else
    PRINTF (("    "ID": compiled for normal operation (debugging disabled)\n",
	(Int) INDEX (UMFPACK_COMPILED_IN_DEBUG_MODE))) ;
#endif

#ifdef UMFPACK_ARCHITECTURE
    PRINTF (("    computer/operating system: %s\n", UMFPACK_ARCHITECTURE)) ;
#endif

    PRINTF (("    size of int: %g long: %g Int: %g pointer: %g"
	" double: %g (in bytes)\n\n", (double) sizeof (int),
	(double) sizeof (long), (double) sizeof (Int),
	(double) sizeof (void *), (double) sizeof (double))) ;

}

