/* ========================================================================== */
/* === UMFPACK_report_perm ================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Prints a permutation vector.  See umfpack_report_perm.h
    for details.

    Dynamic memory usage:  Allocates a size max(n,1)*sizeof(Int)
    workspace via a single call to UMF_malloc and then frees all of it via
    UMF_free on return.  The workspace is not allocated if an early error
    return occurs  before the workspace is needed.

*/

#include "umf_internal.h"
#include "umf_report_perm.h"
#include "umf_malloc.h"
#include "umf_free.h"

GLOBAL Int UMFPACK_report_perm
(
    const char name [ ],
    Int n,
    const Int P [ ],
    const double Control [UMFPACK_CONTROL]
)
{
    Int prl, *W, status ;

    if (Control)
    {
	prl = (Int) Control [UMFPACK_PRL] ;
    }
    else
    {
	prl = UMFPACK_DEFAULT_PRL ;
    }

    if (prl <= 2)
    {
	return (UMFPACK_OK) ;
    }

    W = (Int *) UMF_malloc (n, sizeof (Int)) ;
    status = UMF_report_perm (name, n, P, W, prl, 1) ;
    (void) UMF_free ((void *) W) ;
    return (status) ;
}

