/* ========================================================================== */
/* === umfpack_report_vector ================================================ */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_report_vector
(
    const char name [ ],
    int n,
    const double X [ ],
    const double Control [UMFPACK_CONTROL]
) ;

long umfpack_l_report_vector
(
    const char name [ ],
    long n,
    const double X [ ],
    const double Control [UMFPACK_CONTROL]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, status ;
    double *X, Control [UMFPACK_CONTROL] ;
    status = umfpack_report_vector ("X", n, X, Control) ;

long Syntax:

    #include "umfpack.h"
    long n, status ;
    double *X, Control [UMFPACK_CONTROL] ;
    status = umfpack_l_report_vector ("X", n, X, Control) ;

Purpose:

    Verifies and prints a real vector.

Returns:

    UMFPACK_OK if Control [UMFPACK_PRL] <= 2 (the input is not checked).

    Otherwise:
    
    UMFPACK_OK if the vector is valid.
    UMFPACK_ERROR_argument_missing if X is missing.
    UMFPACK_ERROR_n_nonpositive if n <= 0.

Arguments:

    char name [ ] ;	Input argument, not modified.

	The name of the vector.  This is optional; no name is
	printed if a (char *) NULL pointer is passed.

    Int n ;		Input argument, not modified.

	X is a real vector of size n.  Restriction: n > 0.

    double X [n] ;		Input argument, not modified.

	A real vector of size n.  X must not be (double *) NULL.

    double Control [UMFPACK_CONTROL] ;	Input argument, not modified.

	If a (double *) NULL pointer is passed, then the default control
	settings are used.  Otherwise, the settings are determined from the
	Control array.  See umfpack_defaults on how to fill the Control
	array with the default settings.  The following Control parameters
	are used:

	Control [UMFPACK_PRL]:  printing level.

	    2 or less: no output.  returns silently without checking anything.
	    3: fully check input, and print a short summary of its status
	    4: as 3, but print first few entries of the input
	    5: as 3, but print all of the input
	    Default: 1

*/

