/* ========================================================================== */
/* === umfpack_transpose ==================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_transpose
(
    int n,
    const int Ap [ ],
    const int Ai [ ],
    const double Ax [ ],
    const int P [ ],
    const int Q [ ],
    int Cp [ ],
    int Ci [ ],
    double Cx [ ]
) ;

long umfpack_l_transpose
(
    long n,
    const long Ap [ ],
    const long Ai [ ],
    const double Ax [ ],
    const long P [ ],
    const long Q [ ],
    long Cp [ ],
    long Ci [ ],
    double Cx [ ]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, status, *Ap, *Ai, *P, *Q, *Cp, *Ci ;
    double *Ax, *Cx ;
    status = umfpack_transpose (n, Ap, Ai, Ax, P, Q, Cp, Ci, Cx) ;

long Syntax:

    #include "umfpack.h"
    long n, status, *Ap, *Ai, *P, *Q, *Cp, *Ci ;
    double *Ax, *Cx ;
    status = umfpack_l_transpose (n, Ap, Ai, Ax, P, Q, Cp, Ci, Cx) ;

Purpose:

    Transposes and optionally permutes a sparse matrix in row or column-form,
    C = (PAQ)'.  In Matlab notation, C = (A (P,Q))'.  Alternatively, this
    routine can be viewed as converting A (P,Q) from column-form to row-form,
    or visa versa.  Empty rows and columns may exist.
    The matrix A may be singular.

    umfpack_transpose is useful if you want to factorize A' instead of A.
    Factorizing A' instead of A can be much better, particularly if AA' is much
    sparser than A'A.  You can still solve Ax=b if you factorize A', by solving
    with the sys argument "A'x=b" in umfpack_*solve.

    The input A and output C can be printed with umfpack_report matrix, and the
    permutation vectors can be printed with umfpack_report_perm.

Returns:

    UMFPACK_OK if successful.
    UMFPACK_ERROR_out_of_memory if umfpack_transpose fails to allocate a
	size-n workspace.
    UMFPACK_ERROR_argument_missing if Ai, Ap, Ci, and/or Cp are missing.
    UMFPACK_ERROR_n_nonpositive if n <= 0.
    UMFPACK_ERROR_invalid_permutation if P and/or Q are invalid.
    UMFPACK_ERROR_nz_negative if Ap [n] < 0.
    UMFPACK_ERROR_Ap0_nonzero if Ap [0] != 0.
    UMFPACK_ERROR_col_length_negative if Ap [j] > Ap [j+1] for any j in the
	range 0 to n-1.
    UMFPACK_ERROR_row_index_out_of_bounds if any row index i is < 0 or >= n.
    UMFPACK_ERROR_jumbled_matrix if the row indices in any column are not in
	ascending order.

Arguments:

    Int n ;		Input argument, not modified.

	A is an n-by-n matrix.  Restriction: n > 0.

    Int Ap [n+1] ;	Input argument, not modified.

	The column pointers of the column-oriented form of the matrix A.  See
	umfpack_symbolic for a description.  The number of entries in
	the matrix is nz = Ap [n].  Ap [0] must be zero, Ap [n] must be > 0, and
	Ap [j] <= Ap [j+1] and Ap [j] <= Ap [n] must be true for all j in the
	range 0 to n-1.  Empty columns are OK (that is, Ap [j] may equal Ap
	[j+1] for any j in the range 0 to n-1).

    Int Ai [nz] ;	Input argument, not modified, of size nz = Ap [n].

	The nonzero pattern (row indices) for column j is stored in
	Ai [(Ap [j]) ... (Ap [j+1]-1)].  The row indices in a given column j
	must be in ascending order, and no duplicate row indices may be present.
	Row indices must be in the range 0 to n-1 (the matrix is 0-based).

    double Ax [nz] ;	Input argument, not modified, of size nz = Ap [n].

	If present, these are the numerical values of the sparse matrix A.
	The nonzero pattern (row indices) for column j is stored in
	Ai [(Ap [j]) ... (Ap [j+1]-1)], and the corresponding numerical values
	are stored in Ax [(Ap [j]) ... (Ap [j+1]-1)].  If Ax and/or Cx are not
	present, then the output Cx [...] is not computed, and only the pattern
	is transposed.  This is not an error condition.

    Int P [n] ;		Input argument, not modified.

	The permutation vector P is defined as P [k] = i, where the original
	row i of A is the kth row of PAQ.  If you want to use the identity
	permutation for P, simply pass (Int *) NULL for P.  This is not an error
	condition.

    Int Q [n] ;		Input argument, not modified.

	The permutation vector Q is defined as Q [k] = j, where the original
	column j of A is the kth column of PAQ.  If you want to use the identity
	permutation for Q, simply pass (Int *) NULL for Q.  This is not an error
	condition.

    Int Cp [n+1] ;	Output argument.

	The column pointers of the matrix C = (A (P,Q))', in the same form
	as the column pointers Ap for the matrix A.

    Int Ci [nz] ;	Output argument.

	The row indices of the matrix C = (A (P,Q))', in the same form
	as the row indices Ai for the matrix A.

    double Cx [nz] ;	Output argument.

	If present, these are the numerical values of the sparse matrix C,
	in the same form as the values Ax of the matrix A.  If Ax and/or Cx
	are not present, then the output Cx [...] is not computed, and only
	the pattern is transposed.  This is not an error condition.

*/

