/* main.c - Contains main function */

#ifndef lint
char RCS_main_c[] =
"$Id: main.c,v 2.6 1999/01/03 13:03:26 caleishm Exp caleishm $  Produced by Chris Leishman & Trevor Cohn.  Ormond College student IT department, 1998.$\n";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <signal.h>
#include "main.h"
#include "buildconf.h"
#include "redir.h"
#include "utils.h"

#ifndef SYSCONFDIR
	#define SYSCONFDIR "/etc/"
#endif
#define CONFIG     "urlredir.conf"
#define DIRSEP     '/'
#define MAXLINELEN 1000

void hup_handler(int);
char *path_concat(const char *, const char *);

/* I hate global variables, but it's the easiest way to pass around the 
	address for logging purposes... */

// char *sourceAddr = NULL;


#ifndef CATCH_HUP
/* More global variables!  But their needed for the signal handler. */

int rflag = FALSE;
#endif


/* The main function obtains the data structure using load_config, then
   reads lines of input from stdin for processing.  It first breaks these
   input lines into url and source address before calling redirect to 
   process the url. */

int main(void)
{
	item *data;
	char *fname;
	char *sourceAddr;
	char line[MAXLINELEN];
	char *url = NULL;
	int i;

   fname = path_concat(SYSCONFDIR, CONFIG);
   data = load_config(fname);

	setbuf(stdin, NULL);
	setbuf(stdout, NULL);
	srand(time(NULL));

#ifndef CATCH_HUP
	signal(SIGHUP, hup_handler);
#endif

	while (fgets(line, MAXLINELEN, stdin) != NULL) {
#ifndef CATCH_HUP
		if (rflag == TRUE) {
#ifdef DEBUG
			printf("Re-reading configuration\n");
#endif
			delete_data(data);
			data = load_config(fname);
			rflag = FALSE;
		}
#endif
	
		strlower(line, MAXLINELEN);
		url = line;
		for(i = 0; line[i] != '\0' && !isspace(line[i]); i++);
		line[i++] = '\0';
		while(line[i] != '\0' && isspace(line[i])) i++;
		sourceAddr = line + i;
		for(;line[i] != '\0' && !isspace(line[i]); i++);
		line[i] = '\0';

#ifdef DEBUG
		printf("Read url %s.  Source address %s.\n", url, sourceAddr);
#endif

		redirect(data, url, sourceAddr); 
	}

	/* We shouldn't be exiting */

	return EXIT_FAILURE;
}


#ifndef CATCH_HUP
/* hup_handler sets the rflag, which causes reread of the config file when
   the next URL is read. */
void hup_handler(int signum)
{
#ifdef DEBUG
	printf("Caught HUP signal\n");
#endif
	rflag = TRUE;
}
#endif



/* path_concat takes a directory and a file and returns a string with
   the two joined together.  The appropriate memory for this string is
   first malloc'ed. */

char *path_concat(const char *dir, const char *file)
{
	char *p_concat;
	int dirsize;

	if (!dir)
		return strdup(file);

	dirsize = strlen(dir);
	p_concat = safemalloc(dirsize + strlen(file) + 2);

	strncpy(p_concat, dir, dirsize); 

	if (file[0] == DIRSEP && p_concat[dirsize-1] == DIRSEP) {
		p_concat[dirsize-1] = '\0';
		dirsize--;
	}
	else if (file[0] != DIRSEP && p_concat[dirsize-1] != DIRSEP) {
		p_concat[dirsize] = DIRSEP;
		p_concat[dirsize+1] = '\0';
		dirsize++;
	}

	strncat (p_concat, file, sizeof(p_concat) - dirsize - 2);

	return p_concat;
}

