/* varray.h,v 1.2 1998/10/10 11:24:22 ripperda Exp */

/*
 * Mesa 3-D graphics library
 * Version:  3.0
 * Copyright (C) 1995-1998  Brian Paul
 * Copyright (C) 1998 Terence Ripperda (ripperda@sgi.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL, TERENCE RIPPERDA, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR  
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * varray.h,v
 * Revision 1.2  1998/10/10 11:24:22  ripperda
 * updates regarding adding of api table, changing all function names
 * from direct OpenGL calls to __glx_ prefaced.
 *
 * Revision 1.1  1998/10/05 04:26:36  ripperda
 * needed files for vertex arrays (misc is for error handling)
 *
 * Revision 3.3  1998/06/07 22:18:52  brianp
 * implemented GL_EXT_multitexture extension
 *
 * Revision 3.2  1998/02/20 04:53:07  brianp
 * implemented GL_SGIS_multitexture
 *
 * Revision 3.1  1998/02/01 20:05:10  brianp
 * added __glx_DrawRangeElements()
 *
 * Revision 3.0  1998/01/31 21:06:45  brianp
 * initial rev
 *
 */


#ifndef VARRAY_H
#define VARRAY_H

#include "glxlib.h"

extern void __glx_EnableClientState(GLenum);
extern void __glx_DisableClientState(GLenum);

extern void __glx_VertexPointer( GLint size, GLenum type, GLsizei stride,
                              const GLvoid *ptr );


extern void __glx_NormalPointer( GLenum type, GLsizei stride, const GLvoid *ptr );


extern void __glx_ColorPointer( GLint size, GLenum type, GLsizei stride,
                             const GLvoid *ptr );


extern void __glx_IndexPointer( GLenum type, GLsizei stride,
                                const GLvoid *ptr );


extern void __glx_TexCoordPointer( GLint size, GLenum type, GLsizei stride,
                                const GLvoid *ptr );

/* GL_SGIS_multitexture */
extern void __glx_MultiTexCoordPointer( GLenum target,
                                     GLint size, GLenum type, GLsizei stride,
                                     const GLvoid *ptr );


/* GL_EXT_multitexture */
extern void __glx_InterleavedTextureCoordSets( GLint );


extern void __glx_EdgeFlagPointer( GLsizei stride, const GLboolean *ptr );


extern void __glx_ArrayElement( GLint i );


extern void __glx_DrawArrays( GLenum mode, GLint first, GLsizei count );


extern void __glx_DrawElements( GLenum mode, GLsizei count,
                             GLenum type, const GLvoid *indices );


extern void __glx_InterleavedArrays( GLenum format, GLsizei stride,
                                  const GLvoid *pointer );


extern void __glx_DrawRangeElements( GLenum mode, GLuint start,
                                  GLuint end, GLsizei count, GLenum type,
                                  const GLvoid *indices );


#endif



