#include <stdio.h>
#include <stdlib.h>


/* Mesa profiling code by Josh Vanderhoof.  Adapted (with emacs'
 * excellent M-% search & replace facility) to glx.so by Keith
 * Whitwell.
 */

/*
 * This is the highest address in glx.so
 */
void glx_highpc(void) { }

#if defined(__GNUC__) && defined(__linux__)

void monstartup( char *lowpc, char *highpc );
void _mcleanup( void );
void glx_lowpc( void );
void glx_highpc( void );

static int profile = 0;

void glx_force_init_prof( void )
{
   FILE *fp;

   if (profile) return;

   profile = 1;

   monstartup( (char *)glx_lowpc, (char *)glx_highpc );

   fprintf(stderr, "Starting profiling, %x %x\n", 
           (unsigned int)glx_lowpc, 
           (unsigned int)glx_highpc);

   if ((fp = fopen( "glx_lowpc", "w" )) != NULL) {
      fprintf( fp, "0x%08x ", (unsigned int)glx_lowpc );
      fclose( fp );
   }
}

/*
 * Start profiling
 */
void __attribute__ ((constructor))
glx_init_prof( void )
{
   FILE *fp;
   char *s = getenv("GLX_SO_MON");

      fprintf(stderr, "\n\n\nIn glx_init_prof\n\n\n");

   if (s == NULL)
      return;

   profile = 1;

   monstartup( (char *)glx_lowpc, (char *)glx_highpc );

      fprintf(stderr, "Starting profiling, %x %x\n", 
              (unsigned int)glx_lowpc, 
              (unsigned int)glx_highpc);

   if ((fp = fopen( "glx_lowpc", "w" )) != NULL) {
      fprintf( fp, "0x%08x ", (unsigned int)glx_lowpc );
      fclose( fp );
   }
}



/*
 * Finish profiling
 */
void __attribute__ ((destructor))
glx_fini_prof( void )
{

   fprintf(stderr, "in glx_fini_prof\n");

   if (profile) {
      _mcleanup( );

      profile = 0;
         fprintf(stderr, "Finished profiling\n");
   }
}



void 
glx_force_fini_prof( void )
{

   fprintf(stderr, "in glx_force_fini_prof\n");

   if (profile) {
      _mcleanup( );

      profile = 0;
         fprintf(stderr, "Finished profiling\n");
   }
}

#else

void force_init_prof( void )
{
}

#endif
