#ifndef GLX_SYMS_H
#define GLX_SYMS_H

#include "vga.h"
#include "vgaPCI.h"
#include "xsmesaP.h"
#include "xaa/xf86xaa.h"
#include "xf86_OSproc.h"

#include "servermd.h"

#undef Xfree


typedef struct mga_ramdac MGARamdacRec;
typedef struct i810_memrange I810MemRange;
typedef struct i810_ringbuffer I810RingBuffer;
struct _riva_hw_inst;


/* This struct contains all the stuff that may not be present in a
 * given X server.  They will be linked to the real symbols (either in
 * the X server or in direct mode) via dlsym().
 *
 * This way a single "glx.so" can be built with all drivers compiled
 * in (including mach64), and run against any Xfree86 X server.  
 *
 * This will also fix the case where XF86_SVGA hasn't been built with
 * support for hardware which *has* been compiled into glx.so, eg the
 * i810.  (The i810 support will be turned off in that case, obviously).
 *
 * TODO:  add TNT and S3VIRGE symbols here.
 */

typedef struct {

   /* Symbols from XF86_SVGA mga driver */
   unsigned char **MGAMMIOBase;
   MGARamdacRec *MGAdac;		
   pciTagRec *MGAPciTag;
   int *MGAchipset;
   int *MGAydstorg;
   Bool *MGAUsePCIRetry;
 
   /* Symbols from XF86_SVGA i810 driver */
   I810MemRange *I810DcacheMem;
   int *I810Chipset;
   I810RingBuffer *I810LpRing;
   unsigned char **I810MMIOBase;
   int *I810FrameBufferLocked;
   void (*I810PrintErrorState)( void );


   /* Symbols from XF86_SVGA tnt driver */
   unsigned int (*rivaBufferOffset)[5];
   struct _riva_hw_inst *riva;
   int *rivaRendered2D;
   void *(**vgaSaveFunc)(void *);
   void (**vgaRestoreFunc)(void *);

   
   /* Symbols from XF86_SVGA s3virge driver */
   pointer *s3vMmioMem;
   void (*S3VPrintRegs)( void );

   /* Symbols from XF86_SVGA sis driver */
   pointer *sisMMIOBase;

   // mach64 server info
   ScrnInfoRec	*mach64InfoRec;	
   pointer	*mach64MemRegMap;
   pointer	*mach64VideoMem;
   unsigned long	*mach64ApertureAddr;	
   unsigned long	*mach64ApertureSize; /* also in fbdev server?  */
   
   // mach64 PPC fbdev server info
   ScrnInfoRec	*fbdevInfoRec;		
   int	*fbdevVirtBase;
   int	*fbdevRegBase;


   /* Symbols from the XF86_SVGA server. */ 
   xf86AccelInfoRecType *xf86AccelInfoRec;
   PciProbeType *xf86PCIFlags;
   ScrnInfoRec *vga256InfoRec;
   int *vgaBytesPerPixel;
   int *vgaBitsPerPixel;
   int *vgaLinearSize;
   pointer *vgaLinearBase;
   int *xf86VTSema;	


   /* Symbols common to all the XF86 servers */
   ExtensionEntry *(*AddExtension)(char*, int, int, int (*)(), int (*)(),
				   void (*)(ExtensionEntry *),
				   unsigned short (*)(ClientPtr));

   unsigned short (*StandardMinorOpcode)(ClientPtr client);

   Bool (*AddResource)(XID, RESTYPE, pointer);
   RESTYPE (*CreateNewResourceType)(DeleteType);
   void (*FreeResource)(XID, RESTYPE);

   pointer (*LookupIDByClass)(XID, RESTYPE);
   pointer (*LookupIDByType)(XID, RESTYPE);
   pointer (*SecurityLookupIDByClass)(ClientPtr, XID, RESTYPE, Mask);
   pointer (*SecurityLookupIDByType)(ClientPtr, XID, RESTYPE, Mask);

   int (*AllocColor)(ColormapPtr, unsigned short*, unsigned short*,
		     unsigned short*, Pixel*, int);
   int (*QueryColors)(ColormapPtr, int, Pixel*, xrgb* );
   void (*ErrorF)(char*, ...);
   void (*FatalError)(char*, ...);
   void (*FlushAllOutput)(void);
   void (*FreeScratchGC)(GCPtr);
   GCPtr (*GetScratchGC)(unsigned, ScreenPtr);
   int (*DoChangeGC)(GCPtr, BITS32, XID*, int);
   void (*ValidateGC)(DrawablePtr, GCPtr);
   void (**GlxExtensionInitPtr)(void);
   Bool (**GlxInitVisualsPtr)(VisualPtr *, DepthPtr *, int *, int *, int *, 
			     VisualID *, unsigned long, int);
   XID (*FakeClientID)(int);
   WindowPtr (*FindWindowWithOptional)(WindowPtr);
   int (*LocalClient)(ClientPtr);
   int (*WriteToClient)(ClientPtr, int, char*);
   unsigned long *(*Xalloc)(unsigned long);
   void (*Xfree)(void *);
   pointer (*xf86MapVidMem)(int, int, pointer, unsigned long);
   void (*xf86UnMapVidMem)(int, int, pointer, unsigned long);
   PaddingInfo (*PixmapWidthPaddingInfo)[33];
   ScreenInfo *screenInfo;

   /* Symbols which are never used by direct clients:
    */
   CARD32 (*pcibusRead)(pciTagRec, CARD32);
   void (*pcibusWrite)(pciTagRec, CARD32, CARD32);

} GlxDriverSyms;


extern GlxDriverSyms glxsym;

#define GLXSYM(x) (*(glxsym.x))


/* Symbols common to all XFree86 3.3 servers:
 */
extern int glxHookXFree86Symbols( void *handle );

/* Symbols specific particular XF86 servers:
 */
extern int glxHookSVGAServerSymbols( void *handle );
extern int glxHookFbDevServerSymbols( void *handle );
extern int glxHookMach64ServerSymbols( void *handle );

/* Symbols for particular drivers inside the XF86_SVGA server:
 */
extern int i810HookServerSymbols( void *handle );
extern int mgaHookServerSymbols( void *handle );
extern int s3virgeHookServerSymbols( void *handle );
extern int s3savHookServerSymbols( void *handle );
extern int sis6326HookServerSymbols( void *handle );
extern int nvHookServerSymbols( void *handle );


/* Helper function for direct rendering (called by the driver):
 */
extern int glxInstallLocalSVGASymbols( void );
extern int glxInstallLocalMach64Symbols( void );
extern int glxHookX11ClientSymbols( void );


/* Initialize the module on the client side.
 */
extern ClientPtr glxInitDirectClient( void *display, int screen, 
				      int first_visual,
				      int server, int chipset );


/* Global flags that don't really have a better home:
 */
extern int __glx_is_server;
extern int __glx_first_visual;



/* Why didn't I do this earlier?
 */
#ifndef GLX_SYM_NO_DEFINES
#define AddExtension GLXSYM(AddExtension)
#define StandardMinorOpcode GLXSYM(StandardMinorOpcode)
#define AddResource GLXSYM(AddResource)
#define CreateNewResourceType GLXSYM(CreateNewResourceType)
#define FreeResource GLXSYM(FreeResource)
#define LookupIDByClass GLXSYM(LookupIDByClass)
#define LookupIDByType GLXSYM(LookupIDByType)
#define SecurityLookupIDByClass GLXSYM(SecurityLookupIDByClass)
#define SecurityLookupIDByType GLXSYM(SecurityLookupIDByType)
#define AllocColor GLXSYM(AllocColor)
#define QueryColors GLXSYM(QueryColors)
#define ErrorF GLXSYM(ErrorF)
#define FatalError GLXSYM(FatalError)
#define FlushAllOutput GLXSYM(FlushAllOutput)
#define FreeScratchGC GLXSYM(FreeScratchGC)
#define GetScratchGC GLXSYM(GetScratchGC)
#define DoChangeGC GLXSYM(DoChangeGC)
#define ValidateGC GLXSYM(ValidateGC)
#define GlxExtensionInitPtr GLXSYM(GlxExtensionInitPtr)
#define GlxInitVisualsPtr GLXSYM(GlxInitVisualsPtr)
#define FakeClientID GLXSYM(FakeClientID)
#define FindWindowWithOptional GLXSYM(FindWindowWithOptional)
#define LocalClient GLXSYM(LocalClient)
#define WriteToClient GLXSYM(WriteToClient)
#define Xalloc GLXSYM(Xalloc)
#define Xfree GLXSYM(Xfree)
#define xf86MapVidMem GLXSYM(xf86MapVidMem)
#define xf86UnMapVidMem GLXSYM(xf86UnMapVidMem)
#define PixmapWidthPaddingInfo GLXSYM(PixmapWidthPaddingInfo)
#define screenInfo GLXSYM(screenInfo)
#define pcibusRead GLXSYM(pcibusRead)
#define pcibusWrite GLXSYM(pcibusWrite)
#endif

#endif
