#include "glx_symbols.h"
#include "i810.h"

#include <dlfcn.h>
#include <stdio.h>

static I810MemRange I810DcacheMem;
static int I810Chipset;
static I810RingBuffer I810LpRing;
static unsigned char *I810MMIOBase;
static int I810FrameBufferLocked;
static void I810PrintErrorState( void ) {}


int i810InstallLocalSymbols( void )
{
   glxsym.I810DcacheMem = &I810DcacheMem;
   glxsym.I810Chipset = &I810Chipset;
   glxsym.I810LpRing = &I810LpRing;
   glxsym.I810MMIOBase = &I810MMIOBase;
   glxsym.I810FrameBufferLocked = &I810FrameBufferLocked;
   glxsym.I810PrintErrorState = &I810PrintErrorState;

   return glxInstallLocalSVGASymbols();
}

static int any_error;
static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
   if ((error = dlerror()) != 0) {
      fputs(error, stderr);
      any_error = 1;
      return 0;
   }
   return tmp;
}

int i810HookServerSymbols( void *handle )
{
   glxsym.I810DcacheMem = my_dlsym(handle, "I810DcacheMem");
   glxsym.I810Chipset = my_dlsym(handle, "I810Chipset");
   glxsym.I810LpRing = my_dlsym(handle, "I810LpRing");
   glxsym.I810MMIOBase = my_dlsym(handle, "I810MMIOBase");
   glxsym.I810FrameBufferLocked = my_dlsym(handle, "I810FrameBufferLocked");
   glxsym.I810PrintErrorState = my_dlsym(handle, "I810PrintErrorState");

   if (!any_error) 
      ErrorF("Sucessfully initialized i810 driver symbols\n");
   else
      ErrorF("I810 driver disabled due to missing symbols\n");

   return !any_error;
}
