/*
 * GLX Hardware Device Driver for Intel i810
 * Copyright (C) 1999 Keith Whitwell
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * KEITH WHITWELL, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 */

/* $Id: i810tex.h,v 1.1 1999/12/13 12:47:45 keithw Exp $ */

#ifndef I810TEX_INC
#define I810TEX_INC

#include "mesaglx/types.h"
#include "mmath.h"

#include "i810common.h"
#include "i810buf.h"

#define VALID_I810_TEXTURE_OBJECT(tobj)  (tobj) 

#define I810_TEX_MAXLEVELS 10

struct i810_texture_object_t {
   struct i810_texture_object_t *next, *prev;

   GLuint age;   
   struct gl_texture_object *globj;
     
   int Pitch;
   int Height;
   int texelBytes;
   int totalSize;

   PMemBlock MemBlock;
   
   char *BufAddr;

   GLuint min_level;
   GLuint max_level;
   GLuint dirty_images;

   struct { 
      const struct gl_texture_image *image;
      int offset;		/* into BufAddr */
      int height;
      int internalFormat;
   } image[I810_TEX_MAXLEVELS];

   /* Support for multitexture.
    */
   GLuint current_unit;		
   
   GLuint Setup[I810_TEX_SETUP_SIZE];
   GLuint reg_dirty;

   GLushort Palette[256];
   int UsePalette;
};		

#define I810_NO_PALETTE        0x0
#define I810_USE_PALETTE       0x1
#define I810_UPDATE_PALETTE    0x2
#define I810_FALLBACK_PALETTE  0x4

typedef struct i810_texture_object_t *i810TextureObjectPtr;

i810TextureObjectPtr i810CreateTexObj(i810ContextPtr ctx,
				    struct gl_texture_object *tObj);
int i810DestroyTexObj(i810ContextPtr ctx, i810TextureObjectPtr t);
void i810UpdateTextureState(GLcontext *ctx);


/* Driver functions */

void i810TexEnv( GLcontext *ctx, GLenum pname, const GLfloat *param );

void i810TexImage( GLcontext *ctx, GLenum target,
		  struct gl_texture_object *tObj, GLint level,
		  GLint internalFormat,
		  const struct gl_texture_image *image );

void i810TexSubImage( GLcontext *ctx, GLenum target,
		  struct gl_texture_object *tObj, GLint level,
		  GLint xoffset, GLint yoffset,
		  GLsizei width, GLsizei height,
		  GLint internalFormat,
		  const struct gl_texture_image *image );

void i810TexParameter( GLcontext *ctx, GLenum target,
		      struct gl_texture_object *tObj,
		      GLenum pname, const GLfloat *params );

void i810BindTexture( GLcontext *ctx, GLenum target,
		     struct gl_texture_object *tObj );

void i810DeleteTexture( GLcontext *ctx, struct gl_texture_object *tObj );

void i810UpdateTexturePalette( GLcontext *ctx, struct gl_texture_object *tObj );
void i810UseGlobalTexturePalette( GLcontext *ctx, GLboolean state );

#endif
