/* $Id: rage_reg.h,v 1.8 2000/03/25 06:52:32 gareth Exp $ */

/*
 * GLX Hardware Device Driver for ATI Rage Pro
 * Copyright (C) 1999 Gareth Hughes
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *    Gareth Hughes <gareth@precisioninsight.com>
 */

#ifndef __RAGE_REG_H__
#define __RAGE_REG_H__

#if defined(__alpha__)

#define mb()			__asm__ __volatile__("mb": : :"memory")
#define INREG8( addr )		xf86ReadSparse8( mach64glx.MMIOBase, (addr) )
#define INREG16( addr )		xf86ReadSparse16( mach64glx.MMIOBase, (addr) )
#define INREG( addr )		xf86ReadSparse32( mach64glx.MMIOBase, (addr) )
#define OUTREG8( addr, val )					\
do {								\
    xf86WriteSparse8( (val), mach64glx.MMIOBase, (addr) );		\
    mb();							\
} while( 0 )
#define OUTREG16( addr, val )					\
do {								\
    xf86WriteSparse16( (val), mach64glx.MMIOBase, (addr) );		\
    mb();							\
} while ( 0 )
#define OUTREG( addr, val )					\
do {								\
    xf86WriteSparse32( (val), mach64glx.MMIOBase, (addr) );		\
    mb();							\
} while ( 0 )

#else /* __alpha__ */

#if defined(EXTRADEBUG)

CARD8  dbg_inreg8( int, int );
CARD16 dbg_inreg16( int, int );
CARD32 dbg_inreg32( int, int );
void dbg_outreg8( int, int );
void dbg_outreg16( int, int );
void dbg_outreg32( int, int );
#define INREG8( addr )		dbg_inreg8( addr, 1 )
#define INREG16( addr )		dbg_inreg16( addr, 1 )
#define INREG( addr )		dbg_inreg32( addr, 1 )
#define OUTREG8( addr, val )	dbg_outreg8( addr, val )
#define OUTREG16( addr, val )	dbg_outreg16( addr, val )
#define OUTREG( addr, val )	dbg_outreg32( addr, val )

#else /* EXTRADEBUG */

#define INREG8( addr )		*(volatile CARD8 *)(mach64glx.MMIOBase + (addr))
#define INREG16( addr )		*(volatile CARD16 *)(mach64glx.MMIOBase + (addr))
#define INREG( addr )		*(volatile CARD32 *)(mach64glx.MMIOBase + (addr))
#define OUTREG8( addr, val )	*(volatile CARD8 *)(mach64glx.MMIOBase + (addr)) = (val)
#define OUTREG16( addr, val )	*(volatile CARD16 *)(mach64glx.MMIOBase + (addr)) = (val)
#define OUTREG( addr, val )	*(volatile CARD32 *)(mach64glx.MMIOBase + (addr)) = (val)

#endif /* EXTRADEBUG */
#endif /* __alpha__ */

#define MACH64_ISBUSY()		( SWAP(INREG( MACH64_GUI_STAT )) & 0x00000001 )
#define MACH64_WAITFIFO()						\
    while ( SWAP(INREG( MACH64_FIFO_STAT )) & 0x0000ffff )
#define MACH64_WAITFREE()						\
    do {								\
	MACH64_WAITFIFO();						\
	while ( MACH64_ISBUSY() );					\
    } while ( 0 )
#define MACH64_WAITFIFOSLOTS( slots )					\
    while ( ( SWAP(INREG( MACH64_FIFO_STAT )) & 0x0000ffff ) >		\
	    ( ( 0x00008000 >> (slots) ) ) )

#define MACH64_IS_RAGEPRO(chip)		(((chip) == PCI_MACH64_GB_ID) || \
					 ((chip) == PCI_MACH64_GD_ID) || \
					 ((chip) == PCI_MACH64_GI_ID) || \
					 ((chip) == PCI_MACH64_GP_ID) || \
					 ((chip) == PCI_MACH64_MB_ID) || \
					 ((chip) == PCI_MACH64_GQ_ID))

#endif
