#include "glx_symbols.h"

#include <dlfcn.h>
#include <stdio.h>

#include "riva_hw.h"

#undef NV_DIRECT
#ifdef NV_DIRECT
static unsigned int rivaBufferOffset[5];
static RIVA_HW_INST riva;
static int rivaRendered2D;
static void *(*vgaSaveFunc)(void *);
static void (*vgaRestoreFunc)(void *);

void nvInstallLocalSymbols( void )
{
   glxInstallLocalSVGASymbols();

   glxsym.rivaBufferOffset = &rivaBufferOffset;
   glxsym.riva = &riva;
   glxsym.rivaRendered2D = &rivaRendered2D;
   glxsym.vgaSaveFunc = &vgaSaveFunc;
   glxsym.vgaRestoreFunc = &vgaRestoreFunc;
}
#endif

static int any_error;
static void *my_dlsym(void *handle, const char *name)
{
   void *tmp = dlsym(handle, name);
   char *error;
   if ((error = dlerror()) != 0) {
      fputs(error, stderr);
      any_error = 1;
      return 0;
   }
   return tmp;
}

int nvHookServerSymbols( void *handle )
{
   any_error = 0;

   glxsym.rivaBufferOffset = my_dlsym(handle, "rivaBufferOffset");
   glxsym.riva = my_dlsym(handle, "riva");
   glxsym.rivaRendered2D = my_dlsym(handle, "rivaRendered2D");
   glxsym.vgaSaveFunc = my_dlsym(handle, "vgaSaveFunc");
   glxsym.vgaRestoreFunc = my_dlsym(handle, "vgaRestoreFunc");

   if (!any_error) 
      ErrorF("Sucessfully loaded nv driver\n");
   else
      ErrorF("NV driver disabled due to missing symbols\n");

   return !any_error;
}
