/*
 * GLX Hardware Device Driver for S3 Savage3D and probably Savage/MX and
 * Savage/IX
 * Copyright (C) 2000 Dominik Behr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on S3 Virge driver by Jim Duchek <jimduchek@ou.edu>
 *
 * Dominik Behr <behr@promail.pl>
 * thanks to Raja Koduri and Tim Roberts   
 */

#include "s3savglx.h"
#include "hw_buffer.h"

hwUI32
s3savColorFromRGB(unsigned int uR,
                  unsigned int uG,
		  unsigned int uB)
{
 if (stS3Sav.pDrawBuffer->stBackBuffer.nBPP == 2) 
    return (((uR >> 3) << 11) | ((uG >> 2) << 5) | (uB >> 3));
 else
    return ((uR << 16) | (uG << 8) | (uB));
}
          
void
s3savFill(unsigned int uBufferOffset, /* offset in vidmem */
          unsigned int uBufferStride, /* in pixels */
          unsigned int uBufferBPP,
	  unsigned int uValue,
	  unsigned int uX,
	  unsigned int uY,
	  unsigned int uW,
	  unsigned int uH)
{
 //hwUI32 uOldPBD1, uOldPBD2;
 hwUI32 uPBD1, uPBD2;
 hwUI32 uCmd, uXY, uWH;

 #ifdef EVENT_TRACE
 s3savFIFOWait(1);
 fprintf(stderr, "[s3sav] FILL event %04X\n", s3savInsertEvent());
 #endif
 s3savFIFOWait(4+4+2); 
 BCIRST;
 BCIWR(BCI_CMD_WAIT | BCI_WAIT_3D_IDLE);
 //uOldPBD1 = S3SAVRD(S3SAV_PBD1);
 //uOldPBD2 = S3SAVRD(S3SAV_PBD2);
 uPBD1 = uBufferOffset;
 uPBD2 = uBufferStride | (uBufferBPP << 16) /*| 0x10000000*/ /* BW disable */;
 if (uBufferBPP > 16)
    uPBD2 |= 0x03000000; // 32 bit tile format
 else     
    uPBD1 |= 0x02000000; // 16 bit tile format

 BCISETREG(BCI_PBD1, uPBD1);
 BCISETREG(BCI_PBD2, uPBD2);
 
 uCmd = 0x48000000 | 0x01000000 | 0x02000000 
      | 0x00CC0000 // ROP copy
      | 0x00008000 // send color
      | 0x00000800 // dest PBD
      //| 0x00000000 // src solid
      ;
 uXY = uX | (uY << 16);
 uWH = uW | (uH << 16);
 BCIWR(uCmd);
 BCIWR(uValue);
 BCIWR(uXY);
 BCIWR(uWH);
 //BCISETREG(BCI_PBD1, uOldPBD1);
 //BCISETREG(BCI_PBD2, uOldPBD2);w
 #ifdef FORCE_SHADOW_UPDATE
 s3savUpdateShadow();
 #endif
}	  
	  

/*******************************************************************************

*******************************************************************************/
GLbitfield 
s3savClear(GLcontext *ctx, 
           GLbitfield mask, 
           GLboolean all,
           GLint x, 
           GLint y, 
           GLint width, 
           GLint height) 
{
 unsigned int nX, nY, nW, nH; 
 #ifdef TRACE
 fprintf(stderr, "[s3sav] s3savClear(%08X, ...)\n",
         ctx);
 #endif
 if (mask & GL_COLOR_BUFFER_BIT)
    {
     if (all)
        { 
         nX = 0;
         nY = 0;
	 //nW = stS3Sav.pDrawBuffer->stBackBuffer.nStride / stS3Sav.pDrawBuffer->stBackBuffer.nBPP;
         nW = ALIGN64(stS3Sav.pDrawBuffer->stBackBuffer.nWidth);
	 nH = ALIGN16(stS3Sav.pDrawBuffer->stBackBuffer.nHeight);
        }
     else
        {
	 nX = x;
	 nY = y;
	 nW = width;
	 nH = height;
	}	
     s3savFill(stS3Sav.pDrawBuffer->stBackBuffer.pMemBlock->ofs,
               stS3Sav.pDrawBuffer->stBackBuffer.nStride / stS3Sav.pDrawBuffer->stBackBuffer.nBPP,
    	       stS3Sav.pDrawBuffer->stBackBuffer.nBPP * 8,
	       s3savColorFromRGB(255 * ctx->Color.ClearColor[0],
	                         255 * ctx->Color.ClearColor[1],
				 255 * ctx->Color.ClearColor[2]),
	       nX,
	       nY,
	       nW,
	       nH);
    
     
     mask &= ~GL_COLOR_BUFFER_BIT;
    }
 if ((mask & GL_DEPTH_BUFFER_BIT)
     && stS3Sav.pDrawBuffer->stZBuffer.pMemBlock)
    {
     unsigned int uVal;
     if (all)
        { 
         nX = 0;
         nY = 0;
         nW = ALIGN64(stS3Sav.pDrawBuffer->stZBuffer.nWidth);
	 nH = ALIGN16(stS3Sav.pDrawBuffer->stZBuffer.nHeight);
        }
     else
        {
	 nX = x;
	 nY = y;
	 nW = width;
	 nH = height;
	}	
     uVal = (unsigned int)(ctx->Depth.Clear * 0xFFFF);
     
     #ifdef UNIFIED_BUFFER
     nX += 1024; // second half of buffer
     #endif
     s3savFill(stS3Sav.pDrawBuffer->stZBuffer.pMemBlock->ofs,
               stS3Sav.pDrawBuffer->stZBuffer.nStride / stS3Sav.pDrawBuffer->stZBuffer.nBPP,
    	       stS3Sav.pDrawBuffer->stZBuffer.nBPP * 8,
	       uVal,
	       nX,
	       nY,
	       nW,
	       nH);
     mask &= ~GL_DEPTH_BUFFER_BIT;
    }    	   

 BCIWR(BCI_CMD_WAIT | BCI_WAIT_2D_IDLE);
 
 #ifdef TRACE
 fprintf(stderr, "[s3sav] s3savClear(%08X, ...) OK\n",
         ctx);
 #endif       
 #if 0       
 {
  hwUI16 *p = stS3Sav.aTiledApertures[0];
  unsigned int nX, nY, nW;
  nW = stS3Sav.pDrawBuffer->stBackBuffer.nStride / stS3Sav.pDrawBuffer->stBackBuffer.nBPP;
  for (nY = 0; nY < stS3Sav.pDrawBuffer->stBackBuffer.nHeight * 5; nY++)
      for (nX = 64; nX < 128/*stS3Sav.pDrawBuffer->stBackBuffer.nWidth*/; nX++)   
          p[nX + nY * nW] = (nX & 0x3F) << 5;
 }    
 #endif   
 return mask;
 /*        
 return FallbackBufferClear(ctx, 
                            nNewMask, 
			    all, 
			    x, y, 
			    width, 
			    height);
 */
}


