
/*
 COMPONENTS:
 C_FOG
 C_TEXTURE
*/

{
 const struct vertex_buffer *pVB;
 hwUI8 (*pColors)[4];		
 float fArea;
 unsigned int uFacing;
 #ifdef C_FOG
 hwUI8 (*pSpec)[4];
 #endif

 #ifdef EVENT_TRACE
 s3savFIFOWait(1);
 fprintf(stderr, "[s3sav] TRI event %04X\n", s3savInsertEvent());
 #endif
 
 pVB = pCtx->VB;

 #ifdef HARDCULL
 uFacing = 0; 
 #else
 fArea = ((pVB->Win.data[e1][0] - pVB->Win.data[e0][0]) 
           * (pVB->Win.data[e0][1] - pVB->Win.data[e2][1]) 
       + (pVB->Win.data[e1][1] - pVB->Win.data[e0][1]) 
      	  * (pVB->Win.data[e2][0] - pVB->Win.data[e0][0]));
 if (fArea * pCtx->backface_sign < 0) 
     return; /* culled */

 if (pCtx->TriangleCaps & DD_TRI_LIGHT_TWOSIDE) 
    uFacing = ( fArea > 0.0 ) ^ pCtx->Polygon.FrontBit;
 else
    uFacing = 0; 
 #endif // HARDCULL      

 pColors = pVB->Color[uFacing]->data;
 #ifdef C_FOG
 pSpec = pVB->Spec[uFacing];
 #endif

 s3savFIFOWait(2+SEND_VERTICES*VERTEX_SIZE+2);

 BCIRST;

 #if defined(C_FOG) && defined(C_TEXTURE)
 BCIWR(BCI_CMD_TRILIST | (SEND_VERTICES << 16) 
      );
 #endif
 #if !defined(C_FOG) && defined(C_TEXTURE)
 BCIWR(BCI_CMD_TRILIST | (SEND_VERTICES << 16) 
       | BCI_SKIP_SPECULAR
      );
 #endif
 #if defined(C_FOG) && !defined(C_TEXTURE) 
 BCIWR(BCI_CMD_TRILIST | (SEND_VERTICES << 16) 
       | BCI_SKIP_U | BCI_SKIP_V       
      );
 #endif
 #if !defined(C_FOG) && !defined(C_TEXTURE)
 BCIWR(BCI_CMD_TRILIST | (SEND_VERTICES << 16) 
       | BCI_SKIP_SPECULAR
       | BCI_SKIP_U | BCI_SKIP_V       
      );      
 #endif

 BCIWF(pVB->Win.data[e0][0]);
 BCIWF(stS3Sav.pContext->fViewportHeight-pVB->Win.data[e0][1]);
 BCIWF(pVB->Win.data[e0][2] / 65535.0f);
 BCIWF(pVB->Win.data[e0][3]);
 BCIWR(S3SAVBGRA(pColors[e0][0], pColors[e0][1], pColors[e0][2], pColors[e0][3]));
 #ifdef C_FOG
 BCIWR((((hwUI32)pSpec[e0][3]) << 24) ^ 0xFF000000);
 #endif
 #ifdef C_TEXTURE
 BCIWF(pVB->TexCoordPtr[0]->data[e0][0]);
 BCIWF(pVB->TexCoordPtr[0]->data[e0][1]); 
 #endif
 
 BCIWF(pVB->Win.data[e1][0]);
 BCIWF(stS3Sav.pContext->fViewportHeight-pVB->Win.data[e1][1]);
 BCIWF(pVB->Win.data[e1][2] / 65535.0f);
 BCIWF(pVB->Win.data[e1][3]);
 BCIWR(S3SAVBGRA(pColors[e1][0], pColors[e1][1], pColors[e1][2], pColors[e1][3]));
 #ifdef C_FOG
 BCIWR((((hwUI32)pSpec[e1][3]) << 24) ^ 0xFF000000);
 #endif
 #ifdef C_TEXTURE
 BCIWF(pVB->TexCoordPtr[0]->data[e1][0]);
 BCIWF(pVB->TexCoordPtr[0]->data[e1][1]);
 #endif
 
 BCIWF(pVB->Win.data[e2][0]);
 BCIWF(stS3Sav.pContext->fViewportHeight-pVB->Win.data[e2][1]);
 BCIWF(pVB->Win.data[e2][2] / 65535.0f);
 BCIWF(pVB->Win.data[e2][3]);
 BCIWR(S3SAVBGRA(pColors[e2][0], pColors[e2][1], pColors[e2][2], pColors[e2][3]));
 #ifdef C_FOG
 BCIWR((((hwUI32)pSpec[e2][3]) << 24) ^ 0xFF000000);
 #endif
 #ifdef C_TEXTURE
 BCIWF(pVB->TexCoordPtr[0]->data[e2][0]);
 BCIWF(pVB->TexCoordPtr[0]->data[e2][1]);
 #endif
 
 #ifdef DUPLICATE_LAST_VERTEX
 BCIWF(pVB->Win.data[e2][0]);
 BCIWF(stS3Sav.pContext->fViewportHeight-pVB->Win.data[e2][1]);
 BCIWF(pVB->Win.data[e2][2] / 65535.0f);
 BCIWF(pVB->Win.data[e2][3]);
 BCIWR(S3SAVBGRA(pColors[e2][0], pColors[e2][1], pColors[e2][2], pColors[e2][3]));
 #ifdef C_FOG
 BCIWR((((hwUI32)pSpec[e2][3]) << 24) ^ 0xFF000000);
 #endif
 #ifdef C_TEXTURE
 BCIWF(pVB->TexCoordPtr[0]->data[e2][0]);
 BCIWF(pVB->TexCoordPtr[0]->data[e2][1]);
 #endif
 
 #endif // DUPLICATE_LAST_VERTEX
 
 #ifdef FORCE_SHADOW_UPDATE
 s3savUpdateShadow();
 #endif
 
 #ifdef WAIT_AFTER_EVERY_TRIANGLE
 BCIWR(BCI_CMD_WAIT | BCI_WAIT_3D_IDLE);
 #endif
}
