/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef EXTINFOS_H
#define EXTINFOS_H

#include <visu_extension.h>
#include <visu_nodes.h>
#include <visu_data.h>
#include <extraFunctions/dataNode.h>

/**
 * initExtInfos:
 *
 * Create the extension, it is called by V_Sim on startup and should not
 * used elsewhere.
 *
 * Returns: the newly created #VisuExtension.
 */
VisuExtension* initExtInfos(void);

/**
 * VisuGlExtInfosDrawId:
 * @DRAW_NEVER: don't draw any information on nodes ;
 * @DRAW_SELECTED: draw information only on a list of nodes ;
 * @DRAW_ALWAYS: draw information on all nodes.
 *
 * This enum represents the possibilities for the information drawing.
 */
typedef enum
  {
    DRAW_NEVER,
    DRAW_SELECTED,
    DRAW_ALWAYS
  } VisuGlExtInfosDrawId;
/**
 * VisuGlExtInfosDrawMethod:
 * @EXT_DRAW_METH_NONE: draw nothing ;
 * @EXT_DRAW_METH_ID: draw the id of nodes ;
 * @EXT_DRAW_METH_TYPE: draw the name of node element ;
 * @EXT_DRAW_METH_OTHER: other possible draw rendering method.
 *
 * This enum represents the method for information drawing.
 */
typedef enum
  {
    EXT_DRAW_METH_NONE,
    EXT_DRAW_METH_ID,
    EXT_DRAW_METH_TYPE,
    EXT_DRAW_METH_OTHER
  } VisuGlExtInfosDrawMethod;

/**
 * visu_glExt_infos_setOn:
 * @data: a #VisuData object ;
 * @status: a boolean.
 *
 * Change the status of the informations extension.
 *
 * Returns: TRUE if the calling routine should call visu_object_redraw().
 */
gboolean visu_glExt_infos_setOn(VisuData *data, gboolean status);
/**
 * visu_glExt_infos_drawIds:
 * @data: a #VisuData object ;
 * @nodes: an integer list, terminated with a negative number.
 *
 * Associate a informations extension to the given @data. With this extension,
 * some the number of nodes will be drawn on them. Numbers can be drawn and
 * all nodes (set @nodes to a NULL pointer), or to a restricted list of nodes
 * represented by their numbers. In this case, @nodes can have whatever length
 * but must be terminated by a negative integer. This array is then owned by the
 * extension and should not be freed.
 */
void visu_glExt_infos_drawIds(VisuData *data, int *nodes);
/**
 * visu_glExt_infos_drawElements:
 * @data: a #VisuData object ;
 * @nodes: an integer list, terminated with a negative number.
 *
 * As visu_glExt_infos_drawIds(), but draw the names of elements instead of their
 * numbers.
 */
void visu_glExt_infos_drawElements(VisuData *data, int *nodes);
/**
 * visu_glExt_infos_drawData:
 * @data: a #VisuData object ;
 * @dataNode: a #VisuDataNode object ;
 * @nodes: an integer list, terminated with a negative number ;
 *
 * As visu_glExt_infos_drawIds(), but draw some informations instead of their
 * numbers. The informations are defined by the @dataNode argument.
 */
void visu_glExt_infos_drawData(VisuData *data, VisuDataNode *dataNode, int *nodes);
/**
 * visu_glExt_infos_build:
 * @dataObj: a #VisuData object.
 *
 * Build the OpenGL list representing the informations associated to the given
 * @dataObj. To associate some, use visu_glExt_infos_drawIds(), or visu_glExt_infos_drawElements()
 * or visu_glExt_infos_drawData().
 */
void visu_glExt_infos_build(VisuData *dataObj);

#endif
