/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef GTK_ORIENTATIONCHOOSER_H
#define GTK_ORIENTATIONCHOOSER_H

#include <glib.h>

#include <visu_data.h>

G_BEGIN_DECLS
/**
 * ORIENTATION_CHOOSER_TYPE:
 *
 * Return the associated #GType to the OrientationChooser objects.
 */
#define ORIENTATION_CHOOSER_TYPE         (orientationChooser_get_type ())
/**
 * ORIENTATION_CHOOSER:
 * @obj: the widget to cast.
 *
 * Cast the given object to a #OrientationChooser object.
 */
#define ORIENTATION_CHOOSER(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORIENTATION_CHOOSER_TYPE, OrientationChooser))
/**
 * ORIENTATION_CHOOSER_CLASS:
 * @klass: the class to cast.
 *
 * Cast the given class to a #OrientationChooserClass object.
 */
#define ORIENTATION_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ORIENTATION_CHOOSER_TYPE, OrientationChooserClass))
/**
 * IS_ORIENTATION_CHOOSER:
 * @obj: the object to test.
 *
 * Return if the given object is a valid #OrientationChooser object.
 */
#define IS_ORIENTATION_CHOOSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORIENTATION_CHOOSER_TYPE))
/**
 * IS_ORIENTATION_CHOOSER_CLASS:
 * @klass: the class to test.
 *
 * Return if the given class is a valid #OrientationChooserClass class.
 */
#define IS_ORIENTATION_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ORIENTATION_CHOOSER_TYPE))

/**
 * OrientationChooser:
 *
 * Short form for a #OrientationChooser_struct structure.
 */
typedef struct _OrientationChooser OrientationChooser;
/**
 * OrientationChooserClass:
 *
 * Short form for a #OrientationChooserClass_struct structure.
 */
typedef struct _OrientationChooserClass OrientationChooserClass;

/**
 * OrientationChooserKind:
 * @orientationChooser_direction: this flag specifies that the box coordinates
 *                                are used to identity a direction ;
 * @orientationChooser_normal: this flag specifies that the box coordinates
 *                             are used to identify a normal direction.
 *
 * These values are used when creating an #OrientationChooser, to specify the
 * behavior of the box coordinates. This is due to the fact that the box coordinates
 * are not always orthoggonal.
 */
typedef enum
  {
    orientationChooser_direction,
    orientationChooser_normal
  } OrientationChooserKind;

/**
 * orientationChooser_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #OrientationChooser objects.
 */
GType          orientationChooser_get_type        (void);

/**
 * orientationChooserNew:
 * @kind: to set the box coordinates behavior ;
 * @liveUpdate: raise "values-changed" when a value is changed ;
 * @data: the associated #VisuData to get the box definition (can be NULL) ;
 * @parent: give the parent window to set the modal status and the position.
 *
 * Create a dialog box with three choices to choose a direction in space: the
 * classical orthogonal basis set, the spherical one or the basis set linked
 * to the box. If the @data argument is NULL, this last possibility is made
 * unsensitive. If the kind is set to orientationChooser_direction, the orthogonal
 * coordinates correspond exactly to the box coordinates (after transformation) ;
 * whereas @kind is orientationChooser_normal, the cartesian coordinates are those
 * which give the right normal plane to the direction given in the box coordinates.
 *
 * Returns: a newly created object.
 */
GtkWidget* orientationChooserNew(OrientationChooserKind kind, gboolean liveUpdate,
				 VisuData *data, GtkWindow *parent);
/**
 * orientationChooserSet_orthoValues:
 * @orientation: a #OrientationChooser widget ;
 * @values: three floating point values.
 *
 * Change the direction using the one given in an orthogonal basis
 * set. Update all other values accordingly.
 */
void orientationChooserSet_orthoValues(OrientationChooser *orientation,
				       float values[3]);
/**
 * orientationChooserSet_boxValues:
 * @orientation: a #OrientationChooser widget ;
 * @values: three floating point values.
 *
 * Change the direction using the one given in the box basis
 * set. Update all other values accordingly.
 */
void orientationChooserSet_boxValues(OrientationChooser *orientation,
				     float values[3]);
/**
 * orientationChooserSet_anglesValues:
 * @orientation: a #OrientationChooser widget ;
 * @values: two floating point values.
 *
 * Change the direction using the one given in a spherical basis
 * set. Update all other values accordingly.
 */
void orientationChooserSet_anglesValues(OrientationChooser *orientation,
					float values[2]);
/**
 * orientationChooserGet_orthoValues:
 * @orientation: a #OrientationChooser widget ;
 * @values: a location for three floating point values.
 *
 * Get the current orientation in the orthogonal basis set.
 */
void orientationChooserGet_orthoValues(OrientationChooser *orientation,
				       float values[3]);
/**
 * orientationChooserGet_boxValues:
 * @orientation: a #OrientationChooser widget ;
 * @values: a location for three floating point values.
 *
 * Get the current orientation in the box basis set.
 */
void orientationChooserGet_boxValues(OrientationChooser *orientation,
				     float values[3]);
/**
 * orientationChooserGet_anglesValues:
 * @orientation: a #OrientationChooser widget ;
 * @values: a location for two floating point values.
 *
 * Get the current orientation in the spherical basis set.
 */
void orientationChooserGet_anglesValues(OrientationChooser *orientation,
					float values[2]);

G_END_DECLS

#endif
