/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_PAIRS_H
#define GTK_PAIRS_H

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "visu_pairs.h"
#include "gtk_main.h"

/**
 * GtkPairsInitFunc:
 *
 * Prototype of functions called once on V_Sim start-up.
 */
typedef void (*GtkPairsInitFunc)(void);
/**
 * GtkPairsBuildWidgetsFunc:
 *
 * Prototype of functions that create a container #GtkWidgets will all
 * element needed to change characteristic of a model.
 *
 * Returns: a newly allocated #GtkWidget.
 */
typedef GtkWidget* (*GtkPairsBuildWidgetsFunc)();
/**
 * GtkPairsGetValuesAsLabelFunc:
 * @data: information about a pair.
 *
 * Create a string, internationalised and in UTF-8, that describes the
 * given pair @data. This string is used in a column tree view to
 * summarize the pair description.
 *
 * Returns: a newly created string.
 */
typedef gchar* (*GtkPairsGetValuesAsLabelFunc)(VisuPairData *data);
/**
 * GtkPairsSetValuesFunc:
 * @data: informations about a pair.
 *
 * Prototype of functions used to update the widgets with given pair @data.
 */
typedef void (*GtkPairsSetValuesFunc)(VisuPairData *data);

/**
 * gtkPairsInit:
 *
 * Initialise the default values for the pair dialog. It does not build
 * the interface, use gtkPairsBuild_window() to do it.
 */
void gtkPairsInit();

/**
 * gtkPairsBuild_window:
 * @main: the command panel the about dialog is associated to.
 *
 * Create the dialog window for pairs.
 */
void gtkPairsBuild_window(VisuUiMain *main);
/**
 * gtkPairsBuild_pairs:
 * @main: the command panel the about dialog is associated to ;
 * @dataObj: the #VisuData the pairs are related to (can be NULL, if
 * none is loaded) ;
 * @force: build the pairs even if the window is hidden.
 *
 * Update the list of pairs. This routine must be called only after
 * gtkPairsBuild_window() has been called. The job is done only if the
 * window is visible or if the @force argument is used.
 */
void gtkPairsBuild_pairs(VisuUiMain *main, VisuData *dataObj, gboolean force);
void gtkPairsShow(VisuUiMain *main);

/**
 * gtkPairsSet_specificLabels:
 * @iter: the #GtkTreeIter to set the label ;
 * @label: the value of the label to be set.
 *
 * Change the specific label shown in the treeview of pairs for the
 * given iter. An iter in this treeview can be retrieve using the
 * #GtkPairsIter_struct objects.
 */
void gtkPairsSet_specificLabels(GtkTreeIter *iter, const gchar *label);

/**
 * gtkPairs_createPairs:
 *
 * Wrapper to get the current rendering window, retrieve its VisuData and call
 * visu_pair_build() with appropriate arguments and then emit 'OpenGLAskForReDraw'
 * if needed.
 */
void gtkPairs_createPairs();

/**
 * GtkPairsIter_struct:
 *
 * An iterator on pairs.
 */
typedef struct GtkPairsIter_struct
{
  VisuElement *ele1;
  VisuElement *ele2;
  VisuPairData *data;
  GtkTreeIter iter;
  GList *selected;
  GList *current;
} GtkPairsIter;
/**
 * gtkPairsIter_startSelected:
 * @iter: an iterator.
 *
 * Initialise the given iterator @iter on the first selected pair or
 * set iter->data to NULL if none. If @iter->data is not NULL,
 * gtkPairsIter_nextSelected() must be called until @iter->data is
 * NULL to be sure that @iter->selected list is freed.
 */
void gtkPairsIter_startSelected(GtkPairsIter *iter);
/**
 * gtkPairsIter_nextSelected:
 * @iter: an iterator.
 *
 * Go to the next selected pair or set iter->data to NULL if none.
 */
void gtkPairsIter_nextSelected(GtkPairsIter *iter);

#endif
