/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef TEXT_H
#define TEXT_H

#include <glib.h>

/**
 * OpenGLTextSize:
 * @TEXT_NORMAL: normal size (14) ;
 * @TEXT_SMALL: small text (12).
 *
 * Different text size available in V_Sim.
 */
typedef enum
  {
    TEXT_NORMAL,
    TEXT_SMALL
  } OpenGLTextSize;

/**
 * openGLText_drawChars:
 * @s: a string.
 * @size: the size of the text to render.
 *
 * Draw the given string on the current raster position with default
 * font.
 */
void openGLText_drawChars(gchar *s, OpenGLTextSize size);
/**
 * openGLText_initFontList:
 *
 * Initialise the font drawing with default font (depending on system).
 * It must be called before openGLText_drawChars() and not in a glNewList().
 * Can be called several times, fonts are initialized once only. Use
 * openGLText_rebuildFontList() to force to build a new font list.
 */
void openGLText_initFontList();
/**
 * openGLText_rebuildFontList:
 *
 * Force to buid a new font list (for example new context has changed.
 */
void openGLText_rebuildFontList();

void openGLText_onNewContext();

#endif
