require 'fileutils'
require 'tempfile'

# This class provides an easy way of creating a temporary
# directory and having it removed when the application exits.
#
# TODO: This class doesn't currently delete the temporary
# directory on exit.
class Tempdir
  attr_reader :path

  def initialize(basename="vagrant")
    @path = nil

    # Loop and attempt to create a temporary directory until
    # it succeeds.
    while @path.nil?
      file = Tempfile.new(basename)
      @path = file.path
      file.unlink

      begin
        Dir.mkdir(@path)
      rescue
        @path = nil
      end
    end
  end

  # This deletes the temporary directory.
  def unlink
    FileUtils.rm_rf(@path)
  end
end
