/***************************************************************************
                          dctransferview.h  -  description
                             -------------------
    begin                : Sat Feb 23 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSFERVIEW_H
#define DCTRANSFERVIEW_H

/**
  *@author Mathias Kster
  */

#include <qvaluevector.h>

#include <dclib/dcobject.h>
#include <dclib/cdownloadmanager.h>

#include <dcwidget.h>

#include <DCDialogTransfer.h>

class CObject;
class QListViewItem;

typedef QValueVector<QString> QStringVector;

/** */
class DCTransferQueueItem : public CObject {
public:
	/** construtor */
	DCTransferQueueItem() {
		pObject = 0;
		pItem   = 0;
	};
	/** destructor */
	virtual ~DCTransferQueueItem() {};

	/** */
	CString sHubName;
	/** */
	CString sHubHost;

	/** */
	CObject * pObject;
	/** */
	QListViewItem * pItem;
};

/** */
class DCTransferListItem : public CObject {
public:
	/** construtor */
	DCTransferListItem() {
		pObject = 0;
		pItem   = 0;
	};
	/** destructor */
	virtual ~DCTransferListItem() {};

	/** */
	CObject * pObject;
	/** */
	DC_QProgressListItem * pItem;
};

class DCFileBrowser;
class QWorkspace;
class QTimer;
class DCQTextEdit;

class DCTransferView : public DCDialogTransfer, public CDownloadManager {
Q_OBJECT

public:
	/** construtor */
	DCTransferView(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCTransferView();

	/** */
	void SetWorkspace(QWidget* workspace);
	/** */
	void InitDocument();
	/** */
	void DeInitDocument();
	/** */
	void NewLocalFileBrowser( bool lock );
	/** */
	void NewFileBrowser( QString nick, QString hubname, QString hubhost, QString share );
	/** */
	bool IsUserInQueue( QString Nick, QString Hubname );
	/** returns the list of the local files names in the queue list. The path is included.*/
	void GetLocalFilesList( QStringVector & LocalFiles, ulonglong size = 0);
	/** download manager callback function */
	virtual int DC_DownloadManagerCallBack( CObject * );
	/** overridden so that the columns are resized on show() */
	virtual void show();

protected:
	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * ) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private:
	/** */
	void MessageSlot( CMessageDMSlotObject * msg );
	/** */
	void MessageLog( CMessageLog * msg );
	/** */
	void MessageTransfer( CMessageDMTransferObject * msg );

	/** */
	void ConnectToAllHubs();
	/** */
	void SearchFileClone(QString filename, ulonglong size);
        /** */
	int selectedItems(QListView * list,QPtrList<QListViewItem> & lst);
	/** */
	ulonglong FindTransferID( QListViewItem * item );
	/** */
	eConnectionState GetTransferDirection( ulonglong sid );
	/** */
	bool GetTransferMessageObject( QListViewItem * item, CMessageDMTransferObject * obj );

	/** */
	bool UpdateTransferWaitList( CMessageDMFileObject * msg );
	/** */
	bool UpdateLocalFileList( CMessageDMFileObject * msg );
	/** */
	void EditExistingTransfer( QString & nick, QString & hubname, QString & hubhost, CList<DCHubObject> * list );
	/** */
	CList<CObject> * pMessageList;
	/** */
	CThreadStringList * pViewTransferList;
	/** */
	CThread * Thread;
	/** */
	QWorkspace * pWorkspace;
	/** */
	CList<DCFileBrowser> * pFileList;
	/** */
	QTimer * Timer;
	/** */
	CThreadStringList * pQueueList;
	/** */
	CThreadStringList * pQueueLocalList;
	/** */
	DCQTextEdit * m_pTextEdit_LOG;

private slots:
	/** */
	void timerDone();
	/** */
	void slotRightButtonClickedTransferList( QListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedTransferWaitList( QListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedLocalFilesList( QListViewItem*, const QPoint &, int );
	/** */
	void slotTabWidgetCurrentChange(QWidget*);
	/** */
	void slotDoubleClickedTransferWaitList( QListViewItem* );
	/** */
	void slotRightButtonClickedUserSlotList( QListViewItem*, const QPoint &, int );
	/** */
	void slotRightButtonClickedLog( const QPoint& );
};

/** */
extern DCTransferView * g_pTransferView;

#endif
