/*
 * Copyright (c) 1991-1994 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: audio.h,v 1.20 96/04/26 05:00:42 van Exp $ (LBL)
 */


#ifndef vat_audio_h
#define vat_audio_h

#include <sys/types.h>
#ifdef WIN32
#include <io.h>
#else
#include <sys/ioctl.h>
#endif
#include "observe.h"

#include "ss.h"
#include "iohandler.h"
#include "Tcl.h"

class Audio;
class Event;
class VOXProc;
class Filter;
class Tcl;

#define MAXAUDIOSIZE 2048

class AudioHandler {
public:
	virtual void audio_handle() = 0;
};

class Audio : public TclObject, public Observable, public IOHandler {
    public:
	enum {
		loop_none = 0,
		loop_mike = 1,
		loop_tone6 = 2,
		loop_tone0 = 3,
		loop_tonemax = 4
	};
	enum {
		input_mike = 0,
		input_line = 1,
		input_line2 = 2,
		input_line3 = 3
	};
	enum {
		output_speaker = 0,
		output_phones = 1,
		output_line = 2,
		output_line2 = 3
	};
	enum {
		mode_mikemutesnet = 0,
		mode_none = 1,
		mode_ec = 2,
		mode_netmutesmike = 3
	};
	Audio();
	virtual ~Audio();
	virtual int command(int argc, const char*const* argv);
	virtual int FrameReady() = 0;
	virtual u_char* Read() = 0;
	virtual	void Write(u_char *) = 0;
	virtual void SetRGain(int);
	virtual void SetPGain(int);
	virtual void InputPort(int);
	inline int InputPort() const { return (iport); }
	virtual void OutputPort(int);
	inline int OutputPort() const { return (oport); }
	inline int RGain() const { return (rgain); }
	inline int PGain() const { return (pgain); }
	int Silent(const u_char*, int len) const;
	inline int FileNo() const { return fd; }
	inline int RMuted() const { return (rmute); }
	inline int PMuted() const { return (pmute); }
	inline int Mode() const { return (omode[oport]); }
	inline int HaveAudio() const { return (fd >= 0); }
	virtual void RMute();
	virtual void RUnmute();
	inline void PMute() { pmute |= 1; }
	inline void PUnmute() { pmute &=~ 1; }
	int StrToMode(const char *) const;
	int StrToIPort(const char *) const;
	const char* IPortToStr(int) const;
	int StrToOPort(const char *) const;
	const char* OPortToStr(int) const;
	inline void SetMode(int i, int m) { omode[i] = m; }
	inline void SetMode(int i, const char *s) { SetMode(i, StrToMode(s)); }
	inline void SetLoopback(const int l) { loopback = l; }
	inline int GetLoopback() const { return (loopback); }
	virtual void Catchup(int) {}
	virtual int RDrops() { return 0; }
	virtual int AdjustTime(u_int) { return 0; }
	virtual void Flush() {}
	virtual int CanFilter() const { return 0; }
	virtual int HalfDuplex() const { return 0; }
	void RetrainFilter(int, int);
	int PlayRec(u_char *, u_char *, int);
	virtual void Release();
	virtual void Obtain();
	virtual int inputs() const;
	virtual int input_type(int i) const;
	virtual int outputs() const;
	virtual int output_type(int i) const;
	inline void handler(AudioHandler* p) { handler_ = p; }
    protected:
	int lock_fd;
	void openlock();
	void unlock();
	int lock();

	virtual void dispatch(int mask);
	const u_int blksize;
	int fd;
	int oport;
	int iport;
	int oports;
	int iports;
	int rmute;
	int pmute;
	int omode[8];
	int loopback;
	int sampleclk;
	int rgain, pgain;
	Filter *filter;
	AudioHandler* handler_;
};

#endif
