/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Modify by Salmaso Raffaele <r.salmaso@flashnet.it> 10 Jan 1999
 * added 2 property: Caption and CaptionWrap
 * added new constructor option: tooltip
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef CHECKBUTTON_H
#define CHECKBUTTON_H
#include <vdk/abstract_button.h>
#include <vdk/vdkprops.h>
#include <vdk/tooltips.h>

class VDKForm;
/*!
  \class VDKCheckButton
  \brief this calls provides a check button widget
  \par Signals:
  toggled_signal, received whenever check button is pressed
  \par Examples:
  In ./testvdk/signalwin.cc
 */
class VDKCheckButton: public VDKAbstractButton
{
  VDKTooltip* tooltip;
protected:
  int connectId;
  static void ToggleEvent(GtkWidget *wid, gpointer obj);
public:
  // properties
  /*!
    Setting this property toggles check button state and emits
    toggled_signal. Can be used to check button state as well
  */
  VDKReadWriteValueProp<VDKCheckButton,bool> Checked;
  /*!
    Sets/gets button caption
  */
  VDKReadWriteValueProp<VDKCheckButton, char*> Caption;
  /*!
    Sets/gets button caption wrap
  */
  VDKReadWriteValueProp<VDKCheckButton, bool> CaptionWrap;
  /*!
    Constructor
    \param owner owner form
    \param label a null terminated string
    \param tip a null terminated string
   */
  VDKCheckButton(VDKForm* owner,char* label = (char*) NULL, char* tip = 0);
  virtual ~VDKCheckButton() {}
  /*!
    Toggles check button state
  */
  void Toggle() { Checked = Checked ? false : true; }
  void SetChecked(bool flag) 
    { gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widget),flag);}
  bool GetChecked()
    { return GTK_TOGGLE_BUTTON(widget)->active ? true : false; }

  void SetCaption (char* str);
  char* GetCaption ();
  void SetCaptionWrap (bool flag);
  bool GetCaptionWrap ();

  virtual void SetForeground(VDKRgb color, GtkStateType state)
    {
      _setForeground_(widget,
		      color.red,
		      color.green,
		      color.blue, 
		      state);
    }
#ifdef USE_SIGCPLUSPLUS
 public:
  /*!
      Extended LS signal system:
      Received when button is toggled
     */
  VDKSignal1<void, bool> OnButtonToggled;
#endif  
};

#endif
