/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1999, Salmaso Raffaele
 * Developed by Salmaso Raffaele <r.salmaso@flashnet.it>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef  PIX_TOGGLEBUTTON_H
#define  PIX_TOGGLEBUTTON_H

#include <vdk/togglebutton.h>

class VDKPixmapToggleButton: public VDKToggleButton
{
    GtkWidget *lbl, *box, *pixmap;
    GdkPixmap *gdkpixmap;

public:
    VDKReadWriteValueProp<VDKPixmapToggleButton, char*> Caption;
    VDKReadWriteValueProp<VDKPixmapToggleButton, bool> CaptionWrap;
    VDKPixmapToggleButton (VDKForm* owner,
                           char* pixfile,
                           char* label = NULL,
		           char* tip = NULL,
			   GtkPositionType position = GTK_POS_RIGHT,
			   int padding = 0);
    VDKPixmapToggleButton(VDKForm* owner,
                          char** pixdata,
			  char* label = NULL,
			  char* tip = NULL,
			  GtkPositionType position = GTK_POS_RIGHT,
			  int padding = 0);
    virtual ~VDKPixmapToggleButton();
    virtual void SetForeground(VDKRgb color, 
 			       GtkStateType state = GTK_STATE_NORMAL);
    virtual void SetFont(VDKFont* font);
    virtual void Enable (bool flag = true);
  
    void SetCaption (char* str);
    char* GetCaption ();
    void SetCaptionWrap (bool flag);
    bool GetCaptionWrap ();
  
};
#endif
