/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKCUSTOM_H
#define VDKCUSTOM_H
#include <vdk/vdkobj.h>
#include <vdk/value_sem_list.h>
#include <vdk/vdkarray.h>
#include <vdk/colors.h>
#include <vdk/vdkprops.h>
#ifndef _string_array_def
#define _string_array_def
typedef VDKArray<VDKString> StringArray;
#endif
/*!
  \class Tuple
  This class represent a tuple, a string array with an element
  considered as a primary key.
 */
class Tuple: public StringArray
{
  int KeyIndex;
 public:
  /*!
    Constructor.
    \param n, array dimension
    \param key, ordinal position of the key field ( 0 <= key < n)
   */
  Tuple(int n = 0, int key = 0): StringArray(n),KeyIndex(key) {}
  virtual ~Tuple() {}
  int operator <(Tuple& t) 
    { 
      return (*this)[KeyIndex] < t[KeyIndex]; 
    }
  int operator==(Tuple& t)
    { 
      return (*this)[KeyIndex] == t[KeyIndex]; 
    }
  
};

/*
 */
typedef VDKValueList<Tuple>         TupleList;  
typedef VDKValueListIterator<Tuple> TupleListIterator;
typedef VDKArray<VDKObject*>        VDKObjectArray;
typedef VDKArray<int>               VDKIntArray;
/*!
  \class VDKCustom
  \brief This is a base class for derived VDKCustomList and VDKCustomTree
  Provides common functionalities for both child classes.

 \par Programming tips
  VDKCustom operations are dependent on selection mode that can be one of
  the following:
  \arg GTK_SELECTION_SINGLE (default)
  \arg GTK_SELECTION_BROWSE
  \arg GTK_SELECTION_MULTIPLE
  \arg GTK_SELECTION_EXTENDED

  \par Signals 
  Signals are available for all modes except browse one, but the way you
  can use them is different for each mode. Basically in single mode
  you may use Selection property while in other modes you may use
  Selections() method.
  It's possible to connect with "click_column" signal using dynamics tables
  provided that use connects with <gtk> arg set to false.
  \code
  SignalConnect(aCustom, "click_column",&SomeClass::Response,false);
  \endcode
 */
class VDKCustom: public VDKObject
{
 protected:
  int select_connect,unselect_connect;
 public:
  // properties
  /*!
    Use this to get/set vert. scrollbar policy
   */
  VDKReadWriteValueProp<VDKCustom,GtkPolicyType> VPolicy;
  /*!
    Use this to get/set hor. scrollbar policy
   */
  VDKReadWriteValueProp<VDKCustom,GtkPolicyType> HPolicy;
  /*!
    Use this to get/set border shadow
   */
  VDKReadWriteValueProp<VDKCustom,GtkShadowType> BorderShadow;
  /*!
    Use this to get/set row height
    \par Tip
    By default row height is computed using default font.
   */
  VDKReadWriteValueProp<VDKCustom,int> RowHeight;
  /*!
    Use this to set/get auto resize capablity for al columns
  */
  VDKReadWriteValueProp<VDKCustom,bool> AutoResize;
  /*!
    Since column titiles are themselves objects you can use this
    to access them and set object properties like this:
    \code
    custom->Titles[0]->Enabled = false; 
    custom->Titles[0]->Normalbackground = VDKRgb("dodgerblue");
    \endcode
   */
  VDKObjectArray Titles;
  /*!
    <read-only>, use this to know wich title was selected (if any)
   */
  int SelectedTitle; 
  /*!
    Use this to set colors if they should be different from defaults.
    All new added rows will have this colors. By default this members
    are set to NULLand default colors will be used.
    Tip: to set colors for the entire widget use NormalBackground,...
    proprties.
   */
  VDKColor *UnselectedBackground,*UnselectedForeground,*SelectedBackground,
    *SelectedForeground;

 protected:
  GtkWidget* custom_widget;
  int columns;
  GtkSelectionMode mode;
  virtual void ConnectSignals();
  static void ColumnClick(GtkWidget* , gint column, gpointer s);
  void SetRowHeight(int rh)
    { gtk_clist_set_row_height(GTK_CLIST(custom_widget),rh); }
  void SetAutoResize(bool flag);
  GtkPolicyType GetVPolicy()   { return VPolicy; }
  GtkPolicyType GetHPolicy()   { return HPolicy; }
    //
  void SetVPolicy(GtkPolicyType p)
    {
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (widget),
				      HPolicy, 
				      p);
    }
  void SetHPolicy(GtkPolicyType p)
    { 
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (widget),
				      p, 
				      VPolicy);
    }
  void SetBorderShadow(GtkShadowType bs)
    { gtk_clist_set_shadow_type (GTK_CLIST(custom_widget),bs); }
  GtkShadowType GetBorderShadow() { return BorderShadow; }

 public:
  VDKCustom(VDKForm* owner,
	    int columns = 1,
	    char **titles = NULL,
	    GtkSelectionMode mode = GTK_SELECTION_SINGLE);
  virtual ~VDKCustom();
  /*!
    Returns wich column was clicked
   */
  int ColumnClicked() { return SelectedTitle; } 
  /*!
    Returns selection mode
  */
  GtkSelectionMode SelectionMode();
  /*!
    Returns underlying custom widget.
    \par Tip:
    Use this to access to custom widget, using VDKObject::Widget()
    will access to the widget container not to custom widget itself.
   */
  GtkWidget*    CustomWidget() { return GTK_WIDGET(custom_widget); }
  /*!
    Sets/unsets active titile
    \param col, ordinal position of the active title
    \param flag, either true (set) or false (unset)
   */
  void ActiveTitle(int col, bool flag = true);
  /*!
    Same as above but acts on the entire tuple.
   */
  void ActiveTitles(bool flag = true);
  /*!
    Set/unset titles sensitivity
    \param flag, if false titles will be grayed as well.
   */
  void EnableTitles(bool flag = true);
  /*!
    Freezes widget during time consuming updating operations
  */
  void Freeze(){ gtk_clist_freeze(GTK_CLIST(custom_widget)); }
  /*!
    Unfreeze
   */
  void Thaw() { gtk_clist_thaw(GTK_CLIST(custom_widget)); }
  /*!
    Clear widget
  */
  virtual void Clear() { gtk_clist_clear (GTK_CLIST(custom_widget)); }
  /*!
    Returns how many rows/nodes are into custom widget
  */
  int  Size() { return GTK_CLIST(custom_widget)->rows; }
  /*!
    Set column fixed size
    \param col, ordinal position
    \param size, in pixels
   */
  void ColumnSize(int col, int size);
  /*!
    Sets/unsets column auto-resize capability
    \param col, ordinal position
    \param flag, either true (sets) or false (unsets)
   */
  void AutoResizeColumn(int col,bool flag);
  /*  
      override VDKObject property set
  */
  void SetBackground(VDKRgb, GtkStateType);
  void SetForeground(VDKRgb, GtkStateType);
  void SetFont(VDKFont*);
#ifdef USE_SIGCPLUSPLUS
 public:
     VDKSignal1<void, int> OnColumnClick;
 protected:
     static void make_gtksigc_connection(VDKCustom*);
 private:
     static void _handle_click_column(GtkWidget* wid, int col,
				      gpointer obj);

#endif
};
#endif


