/*  
file: canvaswin.cc
*/ 
#include "canvaswin.h"  
extern char *mini_penguin_xpm[];
static VDKRawPixmap* nicegirl = NULL;
/*
signal map
*/
DEFINE_SIGNAL_MAP(CanvasWin,VDKForm)
  ON_SIGNAL(clearButton,clicked_signal,Clear),
  ON_SIGNAL(nicelinux,clicked_signal,DrawNiceLinux)
END_SIGNAL_MAP 
/*
events map 
*/ 
DEFINE_EVENT_MAP(CanvasWin,VDKForm) 
  ON_EVENT(canvas,motion_notify_event,OnMotion), 
  ON_EVENT(canvas,configure_event,OnConfigure),
  ON_EVENT(canvas,expose_event,OnExpose),
  ON_EVENT(canvas,drag_start_event,OnDragStart),
  ON_EVENT(canvas,dragging_event,OnDragging),
  ON_EVENT(canvas,drag_stop_event,OnDragStop)
END_EVENT_MAP
static char buff[128];
/*
 */ 
void CanvasWin::Setup()    
{
  VDKBox* vbox = new VDKBox(this,v_box); 
  canvas = new VDKCanvas(this,300,200);
  
  canvas->NormalBackground = clIvory;
  canvas->Foreground = clNavyBlue;
  //canvas->Font = new VDKFont(this,fnLucidaTW18);
  canvas->Captured = false;
  canvas->EnableClear = false;
  vbox->Add(canvas);
  vbox->Add(new VDKSeparator(this));  
  VDKBox* hbox = new VDKBox(this,h_box);  
  hbox->Add(label = new VDKLabel(this,"Coords:"));
  /*
    buggy feature
    hbox->Add(mlButton =  
    new VDKPixmapButton(this,
    mini_penguin_xpm,
    "Mother link",
    "Set mother link true"));
  */
  hbox->Add(clearButton = 
	    new VDKLabelButton(this,
			       "Clear", 
			       "Erase canvas"));
  hbox->Add(nicelinux = 
	    new VDKLabelButton(this,
			       "Nice linux",
			       "A nice linux version !"));
  vbox->Add(hbox); 
  Add(vbox);   
  nicegirl=0;
  lastdraw = VDKPoint(0,0);
}   

/* 
 */ 
bool CanvasWin::OnMotion(VDKObject*, GdkEvent* ev)
{
  GdkEventMotion* event = reinterpret_cast<GdkEventMotion*>(ev);
  sprintf(buff,"Coords:%.0f,%.0f",event->x,event->y);
  label->Caption = buff;
  return true;
}

/*
 */
bool CanvasWin::OnConfigure(VDKObject*, GdkEvent*)
{
  canvas->Clear();
  if (!nicegirl)
    {
      canvas->DrawString(80,100,"Hello world !");
      canvas->Cursor = curCrossHair;
    }
  else
    {
      canvas->DrawPixmap(lastdraw.X(),lastdraw.Y(),nicegirl);
    }
  canvas->Redraw();
  return true;
} 
 
/* 
 */
bool CanvasWin::OnDragStart(VDKObject*, GdkEvent* ev)
{
  GdkEventButton* event = reinterpret_cast<GdkEventButton*>(ev);
  canvas->Cursor = curPencil;
  lastdraw = VDKPoint(int(event->x),int(event->y));
  return true;
}

/*   
 */ 
bool CanvasWin::OnDragging(VDKObject*, GdkEvent* ev)
{
  GdkEventMotion* event = reinterpret_cast<GdkEventMotion*>(ev);
  if(!nicegirl)
    {
      GdkRectangle brush;
      brush.x = int(event->x-2);
      brush.y = int(event->y-2);
      brush.width = 4;
      brush.height = 4;
      canvas->DrawRect(true,brush.x,brush.y,brush.width,brush.height);
    }
  else
    {
      canvas->Clear();
      canvas->DrawPixmap(event->x,event->y,nicegirl);
      lastdraw = VDKPoint(event->x,event->y);
    }
  canvas->Redraw();
  return true;
}
  
/*
 */  
bool CanvasWin::OnDragStop(VDKObject*, GdkEvent* )
{
  canvas->Cursor = curCrossHair;  
  return true;
}

/*  
 */
bool CanvasWin::OnExpose(VDKObject*, GdkEvent* )
{ 
  return true;
}

bool CanvasWin::DrawNiceLinux(VDKObject*)
{ 
  canvas->Clear();
  if(!nicegirl)
    {
    nicegirl = new VDKRawPixmap(canvas,"./pixmap/linuxGirl.xpm");
    lastdraw = VDKPoint(0,0);
    }
  canvas->DrawPixmap(lastdraw.X(),lastdraw.Y(),nicegirl);
  canvas->Redraw();
  return true;
} 
  
bool CanvasWin::Clear(VDKObject*) 
{
  if (nicegirl)
    nicegirl = 0;
  OnConfigure(0,0);
  return true;
}   









