/*
file: databoxwin.h
shamelessly stolen to Ionutz
*/ 
#include <stdlib.h>
#include <sys/param.h>
#include <vdk/vdk.h>

#ifndef PI
#define PI 3.14159265358979323846
#endif
#define CHECKS	7
#define POINTS	2000

class DataBoxWin: public VDKForm
{
  VDKCheckButton *_check[CHECKS];
  VDKEntry *_entry;
  VDKDataBox *_databox;
  VDKColor *_red;
  VDKColor *_green;
  
  gfloat _lissajousX[POINTS];
  gfloat _lissajousY[POINTS];
  gfloat _lissajousFrequency;
  gint _lissajousCounter;
  
public:
  DataBoxWin(VDKForm *owner,char* title = "Data box example")
    :VDKForm(owner,title), _lissajousFrequency(3.*PI/2.),
    _lissajousCounter(0)     { }
  
  ~DataBoxWin() { }

  void Setup();
  bool OnToggle(VDKObject *);
  bool OnMarked(VDKObject *);
  bool CanClose();
  static gint OnIdle(gpointer data);

  DECLARE_SIGNAL_LIST(DataBoxWin);
  DECLARE_SIGNAL_MAP(DataBoxWin);
};



