/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4.2
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */               

#include "tchart.h"
#include <stdlib.h>
#define MAX_COLORS 7
struct { int red,green,blue; } colors[MAX_COLORS] =
{
  {255,255,255},
  {255,0,0},
  {0,255,0},
  {0,0,255},
  {255,255,0},
  {0,255,255},
  {255,0,255}
};
const int MIN = 0;
const int MAX = 200;
const int SIZE = 20;
///////////////////////////////////////////////////   
DEFINE_SIGNAL_MAP(ChartForm,VDKForm)
  ON_SIGNAL(quit,clicked_signal,Quit),
  ON_SIGNAL(plot,clicked_signal,Plot),
  ON_SIGNAL(clear,clicked_signal,ClearPlot),
  ON_SIGNAL(combo,selection_changed_signal,OnCombo)
END_SIGNAL_MAP
///////////////////////////////////////////////////
/*
 */
bool ChartForm::OnCombo(VDKObject*)
{
int sel = combo->Selected;
switch(sel)
  {
  case 0:
    LineChart();
    ClearPlot(chart);
    break;
  case 1:
    ScatteredChart();
    ClearPlot(chart);
    break;
  case 2:
    BarChart();
    ClearPlot(chart);
  }
 return true;
}
/*
 */
bool ChartForm::ClearPlot(VDKObject*)
{
if(chart)
  {
    chart->Clear();
    z = 0;
  }
return true;
}
/*
 */

bool ChartForm::Plot(VDKObject*)
{
if(!chart)
  return true;
switch(chart->isA())
  {
  case linechart_class:
    PlotSeries(true,SIZE);
    break;
  case scatteredchart_class:
    PlotSeries(false,SIZE);
    break;
  case barchart_class:
    PlotSeries(false,1); 
    break;
  }
return true;
}
/*
 */

void ChartForm::PlotSeries(bool sort, int size)
{
  int t;
  char buff[32];
  srandom(time(NULL));
  static int range = MAX-MIN;
  Darray x(size),y(size);
  for (t=0; t < size; t++)
    {
      x[t] = MIN + random()%range;
      y[t] = MIN + random()%range; 
    }
  if(sort)
    {
      x.Heapsort();
      y.Heapsort();
    }
  sprintf(buff,"Series %d",++z);
  Series *s = new Series(buff);
  for (t=0; t < x.size(); t++)
    s->Add(x[t],y[t]);
  s->Color = VDKRgb(colors[z%MAX_COLORS].red,
		    colors[z%MAX_COLORS].green,
		    colors[z%MAX_COLORS].blue);
  chart->LabelXDigits = 1;
  chart->LabelYDigits = 1;
  chart->Title = buff;
  chart->LabelX = buff;
  chart->LabelY = buff;
  chart->AddSeries(s);
}
/*
 */
void ChartForm::Setup()
{
  char buff[64];
  frame = new VDKFrame(this,"VDKChart",v_box,shadow_etched_in);
  LineChart();
  Add(frame);
  VDKFrame *frame1 = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  combo = new VDKCombo(this);
  StringList sl = combo->PopdownStrings;
  sl.add("VDKLineChart");
  sl.add("VDKScatteredChart");
  sl.add("VDKBarChart");
  combo->PopdownStrings = sl;
  sprintf(buff,"Plots %d randomly generated points (sorted)",SIZE);
  plot = new VDKLabelButton(this,"Plot",buff);
  clear = new VDKLabelButton(this,"Clear");
  quit = new VDKLabelButton(this,"Quit");
  frame1->Add(combo,FALSE,FALSE,0);
  frame1->Add(plot); 
  frame1->Add(clear);  
  frame1->Add(quit);
  Add(frame1,FALSE,FALSE,0);
}
/*
 */
void ChartForm::LineChart()
{
if(chart)
   frame->RemoveObject(chart);
 chart = new VDKLineChart(this,400,300);
 chart->NormalBackground = clBlack;
 chart->Foreground = clGreen;
 chart->ChartBorder = 60;
 chart->Title = "VDKLineChart";
 frame->Add(chart);
}
/*
 */
void ChartForm::ScatteredChart()
{
  if(chart)
      frame->RemoveObject(chart);
  chart = new VDKScatteredChart(this,400,300);
  chart->NormalBackground = clBlack;
  chart->Foreground = clGreen;
  chart->ChartBorder = 60;
  chart->Title = "VDKScatteredChart";
  frame->Add(chart);
}
/*
 */
void ChartForm::BarChart()
{
  if(chart)
      frame->RemoveObject(chart);
  chart = new VDKBarChart(this,400,300);
  chart->NormalBackground = clBlack;
  chart->Foreground = clGreen;
  chart->ChartBorder = 60;
  chart->Title = "VDKBarChart";
  frame->Add(chart);
}







