/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/label_button.h"
#include "vdk/vdkfont.h"

VDKLabelButton::VDKLabelButton(VDKForm* owner,
                               char* label,
                               char* tip) :
    VDKButton(owner,tip),
    Caption ("Caption", this, label, 
	     &VDKLabelButton::SetCaption, &VDKLabelButton::GetCaption),
    CaptionWrap ("CaptionWrap", this, true, 
		 &VDKLabelButton::SetCaptionWrap, 
		 &VDKLabelButton::GetCaptionWrap)
{
    lbl  = gtk_label_new(label);
    gtk_box_pack_start(GTK_BOX(box),lbl,true,true,1);
    gtk_label_set_justify (GTK_LABEL(lbl),GTK_JUSTIFY_CENTER);
    gtk_misc_set_alignment (GTK_MISC(lbl), .5, .5);
    gtk_widget_show(lbl);
    gtk_widget_show(box);
    gtk_container_add(GTK_CONTAINER(widget),box);
}

