/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * October 1998
 * =========================== 
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
 

#include "vdk/vdkcustom.h"
#include "vdk/forms.h"

void VDKCustom::ColumnClick(GtkWidget* ,
		  gint column,
		  gpointer s)
{ 
  g_return_if_fail(s != NULL);
  VDKObjectSignal* signal = 
    reinterpret_cast<VDKObjectSignal*>(s);
  VDKCustom* obj = reinterpret_cast<VDKCustom*>(signal->obj);
  obj->SelectedTitle = column;
  obj->SignalEmit(signal->signal);
  obj->SignalEmit("click_column");
}
/////////////////////////////////////////////////
/*
 */
VDKCustom::VDKCustom(VDKForm* owner,
			     int columns,
			     char** titles,
			     GtkSelectionMode mode):
  VDKObject(owner),
  VPolicy("VPolicy",this,GTK_POLICY_AUTOMATIC,&VDKCustom::SetVPolicy),
  HPolicy("HPolicy",this,GTK_POLICY_AUTOMATIC,&VDKCustom::SetHPolicy),
  BorderShadow("BorderShadow",this,GTK_SHADOW_ETCHED_OUT,
	       &VDKCustom::SetBorderShadow),
  RowHeight("RowHeight",this,0,&VDKCustom::SetRowHeight),
  AutoResize("AutoResizeColumn",this,true,
	     &VDKCustom::SetAutoResize),
  SelectedTitle(-1),
  UnselectedBackground(NULL),
  UnselectedForeground(NULL),
  SelectedBackground(NULL), 
  SelectedForeground(NULL),
  columns(columns),
  mode(mode)
{
  SelectedTitle = -1;
  if(titles) 
    Titles = VDKObjectArray(columns);
  custom_widget = NULL;
  widget = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (widget),
				  GTK_POLICY_AUTOMATIC, 
				  GTK_POLICY_AUTOMATIC);

} 
/*
 */
VDKCustom::~VDKCustom()
{
}

/*
 */
void
VDKCustom::ConnectSignals()
{
  s_list_click_column.obj = this;
  s_list_click_column.signal = click_column_signal;
  gtk_signal_connect(GTK_OBJECT(custom_widget),
		     "click_column",
		     GTK_SIGNAL_FUNC(VDKCustom::ColumnClick),
		     (gpointer) &s_list_click_column);
}
/*
 */
void 
VDKCustom::SetBackground(VDKRgb c, GtkStateType state)
{
  VDKColor *color = NULL;
  if( !custom_widget) 
    return;
  else
    {
      if(Owner())
	color = new VDKColor(Owner(),c.red,c.green,c.blue);
      else
	color = new VDKColor(this, c.red,c.green,c.blue);
    }
  //    color = new VDKColor(Owner() ? Owner() : this ,
  // 			 c.red,c.green,c.blue);
  /*
    if(!GTK_WIDGET_REALIZED(custom_widget))
    gtk_widget_realize(custom_widget);
    GtkStyle* style = gtk_style_new ();
    g_return_if_fail(style != NULL);
    style->base[state] = *(color->Color());
    gtk_widget_set_style(custom_widget, style );
    gtk_style_unref(style);
  */
   /*    
	 else
	 {
	 GtkRcStyle *style = gtk_rc_style_new ();
	 g_return_if_fail(style != NULL);
	 style->base[state] = *(color->Color());
	 g_return_if_fail(style != NULL);
	 gtk_widget_modify_style (custom_widget, style);
	 gtk_rc_style_unref (style);
	 }
   */
  
  GtkStyle* style = gtk_widget_get_style(custom_widget);
  g_return_if_fail(style != NULL);
  style = gtk_style_copy(style);
  gtk_style_ref(style);
  style->base[state] = *(color->Color());
  gtk_widget_set_style(custom_widget,style);
  
};
/*
 */
void 
VDKCustom::SetForeground(VDKRgb color, GtkStateType state)
{
  if(custom_widget) 
    _setForeground_(custom_widget,color.red,color.green,color.blue, state);
}
/* 
 */
void 
VDKCustom::SetFont(VDKFont* font)
{
  if(custom_widget) 
    _setFont_(custom_widget,font);
}

/*
 */
void VDKCustom::ActiveTitle(int col,bool flag)
{
if(Titles.size() <= 0)
  return;
if(flag) 
  gtk_clist_column_title_active(GTK_CLIST(custom_widget),col);
else
  gtk_clist_column_title_passive(GTK_CLIST(custom_widget),col);
}
/*
 */
void VDKCustom::ActiveTitles(bool flag)
{
for(int t = 0; t < columns; t++)
  ActiveTitle(t,flag);
}
/*
 */
void 
VDKCustom::EnableTitles(bool flag)
{
for(int t = 0; t < columns; t++)
  Titles[t]->Enable(flag);
}
/*
 */ 
GtkSelectionMode
VDKCustom::SelectionMode()  {  return mode; }

/*
 */ 
void
VDKCustom::ColumnSize(int col, int size)
{
if(col < 0 || col >= columns)
  return ;
gtk_clist_set_column_width (GTK_CLIST(custom_widget), col, size);
return;
}
/*
 */
void 
VDKCustom::SetAutoResize(bool flag)
{
  for(int i = 0; i < columns; i++)
    gtk_clist_set_column_auto_resize(GTK_CLIST(custom_widget),
				    i, (gboolean) flag);
  
}
/*
 */
void 
VDKCustom::AutoResizeColumn(int col,bool flag)
{
  gtk_clist_set_column_resizeable(GTK_CLIST(custom_widget),
				  col, (gboolean) flag);
}


#ifdef USE_SIGCPLUSPLUS
void
VDKCustom::make_gtksigc_connection(VDKCustom* obj)
{
     VDKObject::make_gtksigc_connection(obj);
     gtk_signal_connect(GTK_OBJECT(obj->CustomWidget()), "click_column",
			GTK_SIGNAL_FUNC(VDKCustom::_handle_click_column),
			(gpointer) obj);
}

void
VDKCustom::_handle_click_column(GtkWidget* wid, int col,
				gpointer gp)
{
     VDKCustom*  obj=reinterpret_cast<VDKCustom*>(gp);
     obj->OnColumnClick(obj, col);
}
#endif /* USE_SIGCPLUSPLUS */
