/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_GNOME

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#endif

#include <stdlib.h>
#include <vdkb/vdkb_dedit.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_fixed.h>

/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBGnomeDateEdit
// put here vdk class name string
#define VDK_CLASS "VDKGnomeDateEdit"
// put here vdk class name
#define VDK_ANCESTOR  VDKGnomeDateEdit
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "date_edit"
//=================================================================


static char buff[128];
extern char* wi_widget_prompts[];
// used to autogenerate default
int CLASS::Counter = 0;
/*
 properties,signals and nicknames
*/
char* vdkGnomeDateEdit_props[] =
{
    SHOWTIME_INTERNAL,
    FORMAT24_INTERNAL,
    0
};
char* vdkGnomeDateEdit_signals[] =
{
    SIGNAL_ACTIVATE,
    SIGNAL_DATE_CHANGED,
    SIGNAL_TIME_CHANGED,
    SIGNAL_FOCUS_IN,
    SIGNAL_FOCUS_OUT,
    0
};
char* vdkGnomeDateEdit_nicknames[] =
{
    NICK_ACTIVATE,
    NICK_DATE_CHANGED,
    NICK_TIME_CHANGED,
    NICK_FOCUS_IN,
    NICK_FOCUS_OUT,
    0
};
//////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
//////////////////////////////////////
int
StopButtonPress(GtkWidget* w , GdkEvent* event, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,FALSE);
  g_return_val_if_fail(w != NULL,FALSE);
  CLASS* obj = reinterpret_cast<CLASS*>(gp);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(w),
				 "button_press_event");
  // redirect to VDKBObject
  // signal won't stop since there is no signal to stop here
  obj->ButtonPressed(obj->ObjectFromVDK(),event);
  return TRUE;
}
int
StopButtonRelease(GtkWidget* w , GdkEvent* event, gpointer gp)
{
  g_return_val_if_fail(gp != NULL,FALSE);
  g_return_val_if_fail(w != NULL,FALSE);
  CLASS* obj = reinterpret_cast<CLASS*>(gp);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(w),
				 "button_release_event");
  // redirect to VDKBObject
  // signal won't stop since there is no signal to stop here
  obj->ButtonReleased(obj->ObjectFromVDK(),event);
  return TRUE;
}

/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKGnomeDateEdit(owner, (time_t) NULL),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list
  for(t=0; vdkGnomeDateEdit_props[t]; t++)
    proplist.add(VDKBProperty(vdkGnomeDateEdit_props[t]));
  // add to VDKBObject signal list
  for(t=0; vdkGnomeDateEdit_signals[t]; t++)
    siglist.add(VDKBSignal(vdkGnomeDateEdit_signals[t],
			   this,
			   vdkGnomeDateEdit_nicknames[t]));
  // connects events.
  // here we connect internal widgets to button_press/release
  // since they are treated internally instead processed
  // by VDKBObject::ButtonPressed()/ButtonReleased()
  GnomeDateEdit *dedit  = GNOME_DATE_EDIT(ObjectFromVDK()->Widget());
  GtkWidget *toBeStopped = GTK_WIDGET(dedit->date_entry);
  gtk_signal_connect(GTK_OBJECT(toBeStopped),
		     "button_press_event",
		     GTK_SIGNAL_FUNC(StopButtonPress),
		     reinterpret_cast<gpointer>(this));
  gtk_signal_connect(GTK_OBJECT(toBeStopped),	
		     "button_release_event",
		     GTK_SIGNAL_FUNC(StopButtonRelease),
		     reinterpret_cast<gpointer>(this));
  toBeStopped = GTK_WIDGET(dedit->date_button);
  gtk_signal_connect(GTK_OBJECT(toBeStopped),
		     "button_press_event",
		     GTK_SIGNAL_FUNC(StopButtonPress),
		     reinterpret_cast<gpointer>(this));
  gtk_signal_connect(GTK_OBJECT(toBeStopped),
		     "button_release_event",
		     GTK_SIGNAL_FUNC(StopButtonRelease),
		     reinterpret_cast<gpointer>(this));
  EventConnect("enter_notify_event",&VDKBObject::OnEnter);
  EventConnect("leave_notify_event",&VDKBObject::OnLeave);
  EventConnect("motion_notify_event",&VDKBObject::OnMouseMove);
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  //
}
/////////////////////////////////////
//
//          WRITE TO .FRM FILE
//
/////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  //============================
  // USER STUFF BEGINS HERE
  // writes specific properties
  fprintf(fp,"\n\t%s%s;",
	  PROP_SHOWTIME_INTERNAL,
	  (char*) GetProp(SHOWTIME_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_FORMAT24_INTERNAL,
	  (char*) GetProp(FORMAT24_INTERNAL));

}
////////////////////////////////////////
//
//        PREPARE GUI WIDGETS
//
////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
		
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable counter
  // to ensure unicity
  CLASS* edit;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    // actually makes widget
    edit = new CLASS(buff,owner);
  // add widget to form
  return owner->AddToSelf(edit,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  bool obj_showtime,obj_format24;
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  if(parser.GetParam(arg,buffer,PROP_SHOWTIME_INTERNAL) &&
     !strcmp(arg,CHECK_TRUE))
      obj_showtime = true;
  else
      obj_showtime = false;
  if(parser.GetParam(arg,buffer,PROP_FORMAT24_INTERNAL) &&
     !strcmp(arg,CHECK_TRUE))
      obj_format24 = true;
  else
      obj_format24 = false;

  sprintf(tmp,"\n%s = new %s(this,(time_t) NULL,%s,%s);",
	  obj_name,
	  VDK_CLASS,
	  obj_showtime ? CHECK_TRUE : CHECK_FALSE,
	  obj_format24 ? CHECK_TRUE : CHECK_FALSE);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // set widget specific properties
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  bool obj_showtime,obj_format24;
  CLASS* edit;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get constructor args
  if(parser.GetParam(arg,buffer,PROP_SHOWTIME_INTERNAL) &&
     !strcmp(arg,CHECK_TRUE))
      obj_showtime = true;
  else
      obj_showtime = false;
  if(parser.GetParam(arg,buffer,PROP_FORMAT24_INTERNAL) &&
     !strcmp(arg,CHECK_TRUE))
      obj_format24 = true;
  else
      obj_format24 = false;
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      edit = new CLASS(obj_name,owner);
      // pack widget to container
      return owner->PackToSelf(edit, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  inspector = isp;
  VDKString True = CHECK_TRUE;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  // FIX ME: lang support
  VDKTable* table = new VDKTable(inspector,1,2,true);
  showtime = new VDKCheckButton(inspector,
				_(wi_widget_prompts[14]));
  showtime->Checked = GetProp(SHOWTIME_INTERNAL) == True;
  table->AddToCell(showtime,0,0);
  showtime->Parent(this);
  SignalConnect(showtime,"toggled",&CLASS::OnSetShowTime);
  format24 = new VDKCheckButton(inspector,
				_(wi_widget_prompts[15]));
  format24->Checked = GetProp(FORMAT24_INTERNAL) == True;
  table->AddToCell(format24,0,1);
  format24->Parent(this);
  SignalConnect(format24,"toggled",&CLASS::OnSetFormat24);
  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
//////////////////////////////////////////////////////
// These response methods actually change both
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetShowTime(VDKObject*)
{
  SetPropValue(SHOWTIME_INTERNAL,
	       showtime->Checked ? CHECK_TRUE : CHECK_FALSE);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetFormat24(VDKObject*)
{
  SetPropValue(FORMAT24_INTERNAL,
	       format24->Checked ? CHECK_TRUE : CHECK_FALSE);
  inspector->FormNeedToBeChanged();
  return true;
}
#endif







