/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.2
 * May 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
/*
vdkb_envdlg Application
Main unit implementation file:vdkb_envdlg.cc
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_envdlg.h>
#include <vdkb/vdkb.h>
#include <vdk/vdkcolorbrowser.h>
#include <stdlib.h>
extern void create_font_selection (void);
extern char* selected_font;

// Vdkb_envdlg MAIN FORM  CLASS
static char buff[512];
/*
main form constructor
*/
Vdkb_envdlgForm::Vdkb_envdlgForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
Changed = false;
}

/*
main form destructor
*/
Vdkb_envdlgForm::~Vdkb_envdlgForm()
{
}

/*
main form setup
*/
void
Vdkb_envdlgForm::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here
  // initializes env settings
  VDKString Yes = CHECK_YES;
  // General
  CppSourceEntry->Text =   (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  CppHeaderEntry->Text =   (char*) VDKBuilder::ideDefaults.unit.h_ext;
  ObjectFilesButton->Enabled = false;
  ObjectEntry->Text =   "o";
  ObjectEntry->SetTip(_("Fixed to be \"o\""));
  ObjectEntry->Editable = false;
  StartupDirEntry->Text = (char*) VDKBuilder::ideDefaults.project.startupdir;
  // Editor
  EditorFontEntry->Text = (char*) VDKBuilder::ideDefaults.editor.font;

  EditorFgCanvas->NormalBackground =
    VDKRgb((char*) VDKBuilder::ideDefaults.editor.fg);
  EditorBgCanvas->NormalBackground =
    VDKRgb((char*) VDKBuilder::ideDefaults.editor.bg);

  sprintf(buff,"%d", VDKBuilder::ideDefaults.editor.size.X());
  EditorMinHSizeEntry->Text = buff;
  sprintf(buff,"%d", VDKBuilder::ideDefaults.editor.size.Y());
  BackupCheck->Checked = 
    VDKBuilder::ideDefaults.editor.backup == Yes;
  // project
  EditorMinVSizeEntry->Text = buff;
  AutosaveCheck->Checked = 
    VDKBuilder::ideDefaults.project.autosave == Yes;
  HideOnRunCheck->Checked = 
    VDKBuilder::ideDefaults.project.hide_on_run == Yes;
  WiResizeableCheck->Checked = 
    VDKBuilder::ideDefaults.project.wi_resizeable == Yes;
#ifdef HAVE_SYNTAX
  // syntax colors
  char *comments = N_("Comments"), *const_chars = N_("Const chars"),
    *const_strings = N_("Const strings"), *keywords = N_("Key words"),
    *preprocessor = N_("Preprocessor directives");
  char* p = _(comments);
  SyntaxTokenList->AddRow(&p);
  p = _(const_chars);
  SyntaxTokenList->AddRow(&p);
  p = _(const_strings);
  SyntaxTokenList->AddRow(&p);
  p = _(keywords);
  SyntaxTokenList->AddRow(&p);
  p = _(preprocessor);
  SyntaxTokenList->AddRow(&p);
#endif
  // editor tab
  float tabNo = atof((char*) VDKBuilder::ideDefaults.editor.tab);
  editortab->ValueAsFloat = float(tabNo);
  vdk_ref_path->Text = 
    (char*) VDKBuilder::ideDefaults.project.vdk_ref_path;
  save_session->Checked = 
    VDKBuilder::ideDefaults.project.save_session == Yes;
  code_indent->Checked = 
    VDKBuilder::ideDefaults.project.code_indent == Yes;
  code_autoindent->Checked = 
    VDKBuilder::ideDefaults.project.code_autoindent == Yes;
  run_modal->Checked = 
    VDKBuilder::ideDefaults.project.run_modal == Yes;
  emacs->Checked = 
    VDKBuilder::ideDefaults.project.emacs == Yes;
  showln->Checked = 
    VDKBuilder::ideDefaults.project.showln == Yes;
  extascii->Checked = 
    VDKBuilder::ideDefaults.project.extascii == Yes;
}

/*
 */
void 
Vdkb_envdlgForm::OnShow(VDKForm*)
{

}

/*
 */
static char * sampletext =
"/*\nhow vdkbuilder uses coloured syntax\n*/\
\n#include <stdio.h>\
\n class Hello\
\n{\
\n Hello()\
\n  {\
\n   printf(\"hello world !\");\
\n   fflush(stdout);\
\n  }\
\n ~Hello() {}\
\n};\
\nint\
\nmain(int argc, char** argv)\
\n{\
\n Hello hello;\n}\n"; 

bool
Vdkb_envdlgForm::OnRealizeSampleText(VDKObject*)
{
  WriteSyntaxSampleText();
  return true;
}
/*
 */
void 
Vdkb_envdlgForm::WriteSyntaxSampleText()
{
  /*
    VDKColor *defcolor =   
    new VDKColor(this, (char*) VDKBuilder::ideDefaults.editor.fg);
  */
  SyntaxSampleText->NormalBackground = 
    VDKRgb((char*) VDKBuilder::ideDefaults.editor.bg);
  SyntaxSampleText->Foreground = 
    VDKRgb((char*) VDKBuilder::ideDefaults.editor.fg);
  char* font = (char*) VDKBuilder::ideDefaults.editor.font;
  VDKFont* edit_font = new VDKFont(this,font);
  if( *edit_font != (GdkFont*) NULL)
    SyntaxSampleText->Font = edit_font;
  else
    edit_font->Destroy();

  VDKColor *comment_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.comment_color);
  VDKFont  *comment_font  = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.comment_font);
  VDKColor *string_const_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.string_const_color);
  VDKFont  *string_const_font = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.string_const_font);
  VDKColor *chars_const_color = new VDKColor(this,
	  (char*) VDKBuilder::ideDefaults.editor.chars_const_color);
  VDKFont  *chars_const_font = new VDKFont(this,
          (char*) VDKBuilder::ideDefaults.editor.chars_const_font);
  VDKColor* key_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.key_color);
  VDKFont*  key_font = new VDKFont(this,
	 (char*) VDKBuilder::ideDefaults.editor.key_font);
  VDKColor* preprocess_color = new VDKColor(this,
	 (char*) VDKBuilder::ideDefaults.editor.preprocess_color);
  
  SyntaxSampleText->Syntax = false;
  SyntaxSampleText->Clear();
  SyntaxSampleText->ClearSyntaxAndPatternsTables();
  SyntaxSampleText->InstallSyntaxTable (comment_color,
					comment_font,
					string_const_color,
					string_const_font,
					chars_const_color,
					chars_const_font);
  
  SyntaxSampleText->InstallPatternTable(key_color, 
					key_font,preprocess_color);
  
  // writes
  int maxundo = SyntaxSampleText->MaxUndo;
  SyntaxSampleText->Freeze();
  SyntaxSampleText->MaxUndo = 0;
  SyntaxSampleText->TextInsert(sampletext);
  SyntaxSampleText->Thaw();
  SyntaxSampleText->Syntax = true;
  SyntaxSampleText->Line = 0;
  SyntaxSampleText->MaxUndo = maxundo;
}

/*
 */
bool
Vdkb_envdlgForm::OnEditorFgButtonClicked(VDKObject* sender)
{
VDKColorBrowserParms parms;
VDKColorBrowser* child = new VDKColorBrowser(this,&parms);
child->Setup();
child->ShowModal();
if(parms.rgb.red >= 0)
  {
  VDKBuilder::ideDefaults.editor.fg = parms.colorname; 
  Changed = true;  
  EditorFgCanvas->NormalBackground =
    VDKRgb(parms.colorname);
  EditorFgCanvas->Clear();
  gtk_widget_draw(EditorFgCanvas->Widget(),NULL);
  }
 return true;
}

/*
 */
bool
Vdkb_envdlgForm::OnEditorBgButtonClicked(VDKObject* sender)
{
VDKColorBrowserParms parms;
VDKColorBrowser* child = new VDKColorBrowser(this,&parms);
child->Setup();
child->ShowModal();
if(parms.rgb.red >= 0)
  {
  VDKBuilder::ideDefaults.editor.bg = parms.colorname; 
  Changed = true;  
  EditorBgCanvas->NormalBackground =
    VDKRgb(parms.colorname);
  EditorBgCanvas->Clear();
  gtk_widget_draw(EditorBgCanvas->Widget(),NULL);
  }
 return true;
}
/*
 */
bool
Vdkb_envdlgForm::OnSyntaxColorsComboClicked(VDKObject* sender)
{
int ndx = SyntaxTokenList->Selected.Row();
 VDKString color = SyntaxColorsCombo->SelectedColor;
if(ndx < 0 || color.isNull())
  return true;
switch(ndx)
  {
  case 0:  // comments
    VDKBuilder::ideDefaults.editor.comment_color =  color;
    break;
  case 1:  // const chars
    VDKBuilder::ideDefaults.editor.chars_const_color =  color;
    break;
  case 2: // const string
    VDKBuilder::ideDefaults.editor.string_const_color = color;
    break;
  case 3: // key words
    VDKBuilder::ideDefaults.editor.key_color = color;
    break;
  case 4: // preprocessor
    VDKBuilder::ideDefaults.editor.preprocess_color = color;
    break;
  }
 Changed = true;
 WriteSyntaxSampleText();
 return true;
}


// signal response method 
bool
Vdkb_envdlgForm::OnEditorSetFontButtonClick(VDKObject* sender)
{
create_font_selection ();
if(selected_font)
  {
    EditorFontEntry->Text = selected_font;
    VDKBuilder::ideDefaults.editor.font = selected_font;
    g_free(selected_font);
    Changed = true;
  }
return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnCppSourceButtonClick(VDKObject* sender)
{
if(strlen(CppSourceEntry->Text) > 0)
  {
    VDKBuilder::ideDefaults.unit.cc_ext = CppSourceEntry->Text;
    Changed = true;
  }
return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnCppHeaderButtonClick(VDKObject* sender)
{
if(strlen(CppHeaderEntry->Text) > 0)
  {
    VDKBuilder::ideDefaults.unit.h_ext = CppHeaderEntry->Text;
    Changed = true;
  }
return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnObjectFilesButtonClick(VDKObject* sender)
{
return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnStartUpDirButtonClick(VDKObject* sender)
{
if(strlen(StartupDirEntry->Text) > 0)
  {
    VDKBuilder::ideDefaults.project.startupdir = StartupDirEntry->Text;
    Changed = true;
  }
 return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnEditorMinVSizeButtonClick(VDKObject* sender)
{
if(strlen(EditorMinVSizeEntry->Text) > 0)
  {
    int y = atoi(EditorMinVSizeEntry->Text);
    int x = VDKBuilder::ideDefaults.editor.size.X();
    if(y > 0 )
      VDKBuilder::ideDefaults.editor.size = VDKPoint(x,y);
    Changed = true;
  }
return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnSetEditorTab(VDKObject* sender)
{
  int tab = editortab->ValueAsInt;
  sprintf(buff,"%d",tab);
  VDKBuilder::ideDefaults.editor.tab = buff;
  Changed = true;
  return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnVDKRefPath(VDKObject* sender)
{
  char* path = vdk_ref_path->Text;
  if(strlen(path))
    VDKBuilder::ideDefaults.project.vdk_ref_path = path;
  else
    VDKBuilder::ideDefaults.project.vdk_ref_path = PROJECT_VDK_REF_PATH;
  Changed = true;
  return true;
}
// signal response method 
bool
Vdkb_envdlgForm::OnEditorMinHSizeButtonClick(VDKObject* sender)
{
if(strlen(EditorMinHSizeEntry->Text) > 0)
  {
    int x = atoi(EditorMinHSizeEntry->Text);
    int y = VDKBuilder::ideDefaults.editor.size.Y();
    if(x > 0 )
      VDKBuilder::ideDefaults.editor.size = VDKPoint(x,y);
    Changed = true;
  }
return true;
}

static char *font_sample = "aAbBcCdDeEfFgG";
// signal response method 
bool
Vdkb_envdlgForm::OnSyntaxTokenListSelectRow(VDKObject* sender)
{
  int ndx = SyntaxTokenList->Selected.Row();

  if(ndx < 0)
    return true;
  else if(!SyntaxColorsCombo->Enabled)
    SyntaxColorsCombo->Enabled = true;

  if(ndx == 4)
    {
      SyntaxFontButton->Enabled = false;
      SyntaxFontEntry->Text = "";
    }
  else if(!SyntaxFontButton->Enabled)
	SyntaxFontButton->Enabled = true;
  
  switch(ndx)
    {
    case 0:  // comments
      SyntaxFontEntry->Foreground =  
	(char*) VDKBuilder::ideDefaults.editor.comment_color;
      SyntaxFontEntry->Font = new VDKFont(this,
	  (char*) VDKBuilder::ideDefaults.editor.comment_font);
      SyntaxFontEntry->Text = font_sample;
      SyntaxColorsCombo->Canvas->NormalBackground =
	VDKRgb((char*) VDKBuilder::ideDefaults.editor.comment_color);
      SyntaxColorsCombo->Canvas->Clear(); 

      break;
    case 1:  // const chars
      SyntaxFontEntry->Foreground =  
	(char*) VDKBuilder::ideDefaults.editor.chars_const_color;
      SyntaxFontEntry->Font = new VDKFont(this, 
	(char*) VDKBuilder::ideDefaults.editor.chars_const_font);
      SyntaxFontEntry->Text = font_sample;
      SyntaxColorsCombo->Canvas->NormalBackground =
	VDKRgb((char*) VDKBuilder::ideDefaults.editor.chars_const_color);
      SyntaxColorsCombo->Canvas->Clear(); 

      break;
    case 2: // const string
      SyntaxFontEntry->Foreground =  
	(char*) VDKBuilder::ideDefaults.editor.string_const_color;
      SyntaxFontEntry->Font = new VDKFont(this, 
	(char*) VDKBuilder::ideDefaults.editor.string_const_font);
      SyntaxFontEntry->Text = font_sample;
      SyntaxColorsCombo->Canvas->NormalBackground =
	VDKRgb((char*) VDKBuilder::ideDefaults.editor.string_const_color);
      SyntaxColorsCombo->Canvas->Clear(); 

      break;
    case 3: // key words
      SyntaxFontEntry->Foreground =  
	(char*) VDKBuilder::ideDefaults.editor.key_color;
      SyntaxFontEntry->Font = new VDKFont(this,
	(char*) VDKBuilder::ideDefaults.editor.key_font);
      SyntaxFontEntry->Text = font_sample;
      SyntaxColorsCombo->Canvas->NormalBackground =
	VDKRgb((char*) VDKBuilder::ideDefaults.editor.key_color);
      SyntaxColorsCombo->Canvas->Clear(); 
      break;
    case 4: // preprocessor
      SyntaxFontEntry->Foreground =  
	(char*) VDKBuilder::ideDefaults.editor.preprocess_color;
      SyntaxFontEntry->Font = new VDKFont(this,
	(char*) VDKBuilder::ideDefaults.editor.key_font);
      SyntaxFontEntry->Text = font_sample;
      SyntaxColorsCombo->Canvas->NormalBackground =
	VDKRgb((char*) VDKBuilder::ideDefaults.editor.preprocess_color);
      SyntaxColorsCombo->Canvas->Clear(); 
      break;
    }
  return true;
}

// signal response method 
bool
Vdkb_envdlgForm::OnSyntaxFontButtonClick(VDKObject* sender)
{
int ndx = SyntaxTokenList->Selected.Row();
if(ndx < 0)
  return true;
create_font_selection ();
if(selected_font)
  {
    SyntaxFontEntry->Font = new VDKFont(this,
					selected_font);
    SyntaxFontEntry->Text = font_sample;
    switch(ndx)
      {
      case 0:  // comments
	VDKBuilder::ideDefaults.editor.comment_font = selected_font;
	break;
      case 1:  // const chars
	VDKBuilder::ideDefaults.editor.chars_const_font = selected_font;
	break;
      case 2: // const string
	VDKBuilder::ideDefaults.editor.string_const_font = selected_font;
	break;
      case 3: // key words
	VDKBuilder::ideDefaults.editor.key_font = selected_font;
	break;
      }
    g_free(selected_font);
    Changed = true;
    WriteSyntaxSampleText();
  }

return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnHideOnRunCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.hide_on_run =
    HideOnRunCheck->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnSaveSessionCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.save_session =
    save_session->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnCodeIndentCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.code_indent =
    code_indent->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnCodeAutoIndentCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.code_autoindent =
    code_autoindent->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnShowlnCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.showln =
    showln->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnExtAsciiCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.extascii =
    extascii->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnRunModalCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.run_modal =
    run_modal->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnEmacsCheckToggled(VDKObject* sender)
{
  VDKBuilder::ideDefaults.project.emacs =
    emacs->Checked ? CHECK_YES : CHECK_NO;
  Changed = true; 
  return true;
}
/*
 */
bool  
Vdkb_envdlgForm::OnWiResizeableCheckToggled(VDKObject* sender)
{
VDKBuilder::ideDefaults.project.wi_resizeable =
  WiResizeableCheck->Checked ? CHECK_YES : CHECK_NO;
Changed = true; 
return true;
}
/*
 */
bool  
Vdkb_envdlgForm::OnQuitButtonClick(VDKObject* sender)
{
Close();
return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnAutosaveCheckToggled(VDKObject* sender)
{
VDKBuilder::ideDefaults.project.autosave =
  AutosaveCheck->Checked ? CHECK_YES : CHECK_NO;
Changed = true; 
return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnTimedAutosaveSpinButtonChanged(VDKObject* sender)
{
int value = TimedAutosaveSpinButton->ValueAsInt;
sprintf(buff,"%d",value);
VDKBuilder::ideDefaults.editor.timedsave = buff;
Changed = true; 
return true;
}
/*
 */
bool 
Vdkb_envdlgForm::OnBackupCheck(VDKObject* sender)
{
VDKBuilder::ideDefaults.editor.backup =
  BackupCheck->Checked ? CHECK_YES : CHECK_NO;
Changed = true; 
return true;
}
/*
 */
bool 
Vdkb_envdlgForm::CanClose()
{
bool answer;
if(!Changed)
  return true;

answer =   Application()->MessageBox(APPNAME,
				     _("Save modified environment ?"),
				     MB_ICONQUESTION|MB_YESNO,
				     _(user_messages[user_ok]),
				     _(user_messages[user_no])) == IDYES;
if(answer)
  SaveEnvironment();
return true;
}

/*
 */
void
Vdkb_envdlgForm::SaveEnvironment()
{
  char local[256];
  FILE* fp;
  VDKString home = ((VDKBuilder*)Application())->user_home;
  VDKString rcfile = DEFAULTS_FILE;
  sprintf(local,"%s/.vdkb/%s",(char*) home,(char*) rcfile);
  if(access(local,F_OK) < 0)
    {
      sprintf(buff,
	      _("%s\ndoes not exists\
\ncreate %s/.vdkb/res/ and\
\ncopy %s there\
\n(operation aborted)"),
	      local,(char*) home,(char*) rcfile);
      Application()->MessageBox(APPNAME,
				buff,
				MB_ICONINFORMATION|MB_OK,
				_(user_messages[user_ok]));
      return;
    }
  fp = fopen(local,"w+");
  if(!fp)
    return;

  fprintf(fp,
"=======================\
\nVDKBuilder\
\n=======================\
\nIDE defaults file\
\n- file is divided in sections\
\n- all text  outside {} is a remark\
\n- case sensitive\
\n- be careful file parser is'nt protected\
\n against syntax errors !\
\n- section format:\
\nsection_name\
\n{\
\nkey: value ;\
\nkey: value ;\
\n,....\
\n}\
\n------------------\
\nSECTIONS BEGIN HERE\
\n------------------\
\nvdkb_units\
\n{\
\ncount: 1;\
\nname: unit;"
);

  fprintf(fp,"\ncc_ext:%s;",
	  (char*)VDKBuilder::ideDefaults.unit.cc_ext);
  fprintf(fp,"\nh_ext:%s;",
	  (char*)VDKBuilder::ideDefaults.unit.h_ext);
fprintf(fp,
"\nobj_ext: o;\n}");

  fprintf(fp,
"-----------------------\
\ndefaults for\
\nproject\
\nTIP:\
\ndo not change prj_ext\
\nmust be fixed to .prj\
\n----------------------\
\nvdkb_project\
\n{\
\ncount: 1;\
\nname: project;\
\nprj_ext: prj;\
");
fprintf(fp,"\nhide_on_run:%s;",
	(char*)VDKBuilder::ideDefaults.project.hide_on_run);
fprintf(fp,"\nautosave:%s;",
	(char*)VDKBuilder::ideDefaults.project.autosave);
fprintf(fp,"\nstartup_dir:%s;",
	(char*)VDKBuilder::ideDefaults.project.startupdir);
fprintf(fp,"\nwi_resizeable:%s;",
	(char*)VDKBuilder::ideDefaults.project.wi_resizeable);
fprintf(fp,"\nvdk_ref_path:%s;",
	(char*)VDKBuilder::ideDefaults.project.vdk_ref_path);
fprintf(fp,"\nsave_session:%s;",
	(char*)VDKBuilder::ideDefaults.project.save_session);
fprintf(fp,"\ncode_indent:%s;",
	(char*)VDKBuilder::ideDefaults.project.code_indent);
fprintf(fp,"\ncode_autoindent:%s;",
	(char*)VDKBuilder::ideDefaults.project.code_autoindent);
fprintf(fp,"\nrun_modal:%s;",
	(char*)VDKBuilder::ideDefaults.project.run_modal);
fprintf(fp,"\nemacs:%s;",
	(char*)VDKBuilder::ideDefaults.project.emacs);
fprintf(fp,"\nshow_line_numbers:%s;",
	(char*)VDKBuilder::ideDefaults.project.showln);
fprintf(fp,"\next_ascii:%s;",
	(char*)VDKBuilder::ideDefaults.project.extascii);
fprintf(fp,"\n}");

fprintf(fp,
"\n-------------------\
\ndefaults for editor\
\n-------------------\
\nfont keyword accept standar xfontsel names\
\nfg,bg accept standard X color\
\nboth names and #hex\
\n--------------------\
\nvdkb_editor\
\n{");
fprintf(fp,"\nfont:%s;",
	(char*)VDKBuilder::ideDefaults.editor.font);
fprintf(fp,"\nfg:%s;",
	(char*)VDKBuilder::ideDefaults.editor.fg);
fprintf(fp,"\nbg:%s;",
	(char*)VDKBuilder::ideDefaults.editor.bg);
fprintf(fp,"\nh_size:%d;",
	VDKBuilder::ideDefaults.editor.size.X());
fprintf(fp,"\nv_size:%d;",
	VDKBuilder::ideDefaults.editor.size.Y());
fprintf(fp,"\ncomment_color:%s;",
	(char*)VDKBuilder::ideDefaults.editor.comment_color);
fprintf(fp,"\nchars_const_color:%s;",
	(char*)VDKBuilder::ideDefaults.editor.chars_const_color);
fprintf(fp,"\nstring_const_color:%s;",
	(char*)VDKBuilder::ideDefaults.editor.string_const_color);
fprintf(fp,"\nkey_color:%s;",
	(char*)VDKBuilder::ideDefaults.editor.key_color);
fprintf(fp,"\npreprocess_color:%s;",
	(char*)VDKBuilder::ideDefaults.editor.preprocess_color);

fprintf(fp,"\ncomment_font:%s;",
	(char*)VDKBuilder::ideDefaults.editor.comment_font);
fprintf(fp,"\nchars_const_font:%s;",
	(char*)VDKBuilder::ideDefaults.editor.chars_const_font);
fprintf(fp,"\nstring_const_font:%s;",
	(char*)VDKBuilder::ideDefaults.editor.string_const_font);
fprintf(fp,"\nkey_font:%s;",
	(char*)VDKBuilder::ideDefaults.editor.key_font);

fprintf(fp,"\ntimed_save:%s;",
	(char*)VDKBuilder::ideDefaults.editor.timedsave);
fprintf(fp,"\nbackup:%s;",
	(char*)VDKBuilder::ideDefaults.editor.backup);
fprintf(fp,"\ntab:%s;",
	(char*)VDKBuilder::ideDefaults.editor.tab);
fprintf(fp,"\n}");
fclose(fp);
}





