/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.5
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_widpopmenu.h>
// for methods and other stuff
#define CLASS VDKBFixed
// put here vdk class name string
#define VDK_CLASS "VDKFixed"
// put here vdk class name
#define VDK_ANCESTOR  VDKFixed
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "fixed"

static char buff[128];
extern char* wi_widget_prompts[];

int CLASS::Counter = 0;
#define VERBOSE 0
/*
 properties
 */
char* vdkfixed_props[] =
{
HAVEGRID,
GRIDHSPACE,GRIDVSPACE,
0
};

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);
// into vdkb_widsel.c
extern "C" void
fixed_draw_grid (GtkWidget * widget,
		 int grid_horz_spacing,
		 int grid_vert_spacing,
		 int grid_style);
/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
/*
FIXED MOVING STUFF
 */
// plm patch
// GtkWidget *grabbed_widget = NULL;

bool
CLASS::OnButtonPressed(VDKObject* sender, GdkEvent* event)
{
  // pass to ancestor so widget will be marked
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
			       "button_press_event");
  VDKBEventContainer::OnButtonPressed(this,event);
  OnExpose(NULL,NULL);
  /*
    plm patch
  if(grabbed_widget)
    {
      gtk_grab_remove(grabbed_widget);
      grabbed_widget = NULL;
    }
  */
  return true;
}
/*
 */
bool
CLASS::OnButtonReleased(VDKObject* sender, GdkEvent* event)
{
  // pass to ancestor so widget will be marked
  gtk_signal_emit_stop_by_name(GTK_OBJECT(sender->WrappedWidget()),
			       "button_release_event");
  /*
    plm patch
  if(grabbed_widget)
    {
      gtk_grab_remove(grabbed_widget);
      grabbed_widget = NULL;
    }
  */
  return true;
}

/*
 */
void
CLASS::ClearMark()
{
  VDKBObject::ClearMark();
  OnExpose(NULL,NULL);
}
/*
 */
void
CLASS::Mark()
{
  VDKBObject::Mark();
  OnExpose(NULL,NULL);
}
/*
 */
bool
CLASS::OnExpose(VDKObject* sender, GdkEvent* ev)
{
  // draw grid
  VDKString True = CHECK_TRUE;
  if(GetProp(HAVEGRID) == True)
    {
      int grid_horz_spacing =
	atoi((char*) GetProp(GRIDHSPACE));
      int grid_vert_spacing =
	atoi((char*) GetProp(GRIDVSPACE));
      grid_horz_spacing = grid_horz_spacing <= 0 ? 8: grid_horz_spacing;
      grid_vert_spacing = grid_vert_spacing <= 0 ? 8: grid_vert_spacing;
      fixed_draw_grid (container, grid_horz_spacing,
		       grid_vert_spacing, 1); // dots
    }
   return true;
}

//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  Init();
 }
/*
 */
void
CLASS::Init()
{
  int t;
  for(t=0; vdkfixed_props[t]; t++)
    proplist.add(VDKBProperty(vdkfixed_props[t]));
  SetPropValue(HAVEGRID,CHECK_TRUE);
  SetPropValue(GRIDHSPACE,"8");
  SetPropValue(GRIDVSPACE,"8");
  AddBox();
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  setsize = new VDKMenuItem(popmenu,_(wi_widget_prompts[19]));
  selectparent =  new VDKMenuItem(popmenu,_(wi_widget_prompts[20]));
  SignalConnect(selectparent,"activate",
		&CLASS::SelectParentContainer);
  delBox = new VDKMenuItem(popmenu,_(wi_widget_prompts[22]));
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  SignalConnect(setsize,"activate",&CLASS::SetBoxSize);
  EventConnect("button_press_event",
	       &CLASS::OnButtonPressed);
  EventConnect("button_release_event",
	       &CLASS::OnButtonReleased);
  EventConnect("expose_event",
	       &CLASS::OnExpose);
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
}
/*
 */
void
CLASS::AddBox()
{
  container = gtk_fixed_new();
  gtk_container_add(GTK_CONTAINER(widget),container);
  gtk_widget_show(container);
}

/*
extra args unused
 */
void
CLASS::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  int x = justify;
  int y = expand;
  /* Calculate real position according to grid & snapping */
  VDKString isTrue = CHECK_TRUE;
  // commented since always disregard fine positioning
  // Bug reported by John Coppens <jcoppens@linux2.uccor.edu.ar>
  /*
    if(GetProp(HAVEGRID) == isTrue)
    {
      int horz_spacing = atoi((char*) GetProp(GRIDHSPACE));
      int vert_spacing = atoi((char*) GetProp(GRIDVSPACE));
      // snaps to grid
      x -= x % horz_spacing;
      y -= y % vert_spacing;
    }
  */
  gtk_fixed_put(GTK_FIXED(container),wid->Widget(),x,y);
  VDKBEventContainer::Add(wid,l_justify,expand,fill,padding);
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid,justify,expand,fill,padding,forceArgs);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  CLASS* fixed = NULL;
  if(owner->Active)
    {
      if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
	// unauthorized operation
	return 2;
      fixed = new CLASS(buff,owner);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<CLASS*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      fixed->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      fixed->SetPropValue(EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(fixed,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(fixed);
	  fixed->outerbox = container;
	}
      else if(! owner->Active->AddToParent(fixed,ev))
	// target isn't a container
	result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result && fixed)
    fixed->Destroy();
  return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventContainer::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	   PROP_BORDERWIDTH,(char*) GetProp(BORDERWIDTH));
  fprintf(fp,"\n\t%s%s;",
	  PROP_HAVEGRID,(char*) GetProp(HAVEGRID));
  fprintf(fp,"\n\t%s%s;",
	  PROP_GRIDHSPACE,(char*) GetProp(GRIDHSPACE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_GRIDVSPACE,(char*) GetProp(GRIDVSPACE));
}

char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char bw[16];
  //char arg[128];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,PARSER_THIS) ||
       !parser.GetParam(obj_parent,buffer,PARSER_PARENT)
       )
    return NULL;
  else
    source = new char[1024];
  sprintf(temp,"\n%s = new %s(this);",obj_name,VDK_CLASS);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->%s(%s",obj_parent,STATEMENT_ADD,obj_name);
  else
    sprintf(temp,"\n%s(%s",STATEMENT_ADD,obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }
  if(parser.GetParam(bw,buffer,PROP_BORDERWIDTH) &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->%s(%s);",obj_name,BORDERWIDTH,bw);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  CLASS* box;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer, PARSER_THIS) ||
       !parser.GetParam(obj_parent,buffer,PARSER_PARENT)
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  int bw; // border width
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
     justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_BORDERWIDTH) &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new CLASS(obj_name,owner->InnerBox());
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new CLASS(obj_name,container);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      char local[16];
      box->BorderWidth(bw);
      sprintf(local,"%d",bw);
      box->SetPropValue(BORDERWIDTH,local);
    }
  if(parser.GetParam(arg,buffer,PROP_HAVEGRID) &&
     strcmp(arg,NIHIL_PROP))
      box->SetPropValue(HAVEGRID,arg);
  if(parser.GetParam(arg,buffer,PROP_GRIDHSPACE) &&
     strcmp(arg,NIHIL_PROP))
      box->SetPropValue(GRIDHSPACE,arg);
  if(parser.GetParam(arg,buffer,PROP_GRIDVSPACE) &&
     strcmp(arg,NIHIL_PROP))
      box->SetPropValue(GRIDVSPACE,arg);
  return true;
}

/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  bool have_grid = false;
  int horz_spacing = 1,vert_spacing = 1;
  VDKString isTrue = CHECK_TRUE;
  have_grid = GetProp("have_grid") == isTrue;
  if(have_grid)
    {
      horz_spacing = atoi((char*) GetProp(GRIDHSPACE));
      vert_spacing = atoi((char*) GetProp(GRIDVSPACE));
    }

  VDKBox* bframe = dynamic_cast<VDKBox*>(VDKBEventContainer::ExtraWidget(isp));
  if(!bframe)
    return NULL;
  VDKTable* table = new VDKTable(inspector,3,2,true);
  setgrid =
    new VDKCustomButton(inspector,_(wi_widget_prompts[23]));
  table->AddToCell(setgrid,0,0);
  setgrid->Parent(this);
  SignalConnect(setgrid,"clicked",&CLASS::OnSetGrid);
  gridcb = new VDKCheckButton(inspector,_(wi_widget_prompts[24]));
  gridcb->Checked = have_grid;
  table->AddToCell(gridcb,0,1);
  table->AddToCell(new VDKLabel(inspector,_(wi_widget_prompts[25])),1,0);
  vspace = new VDKSpinButton(inspector, vert_spacing, 1, 50 , 1 ,0 );
  vspace->SetSize(60,-1);
  table->AddToCell(vspace,1,1);
  table->AddToCell(new VDKLabel(inspector,_(wi_widget_prompts[26])),2,0);
  hspace = new VDKSpinButton(inspector, horz_spacing, 1, 50 , 1 ,0 );
  hspace->SetSize(60,-1);
  table->AddToCell(hspace,2,1);
  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
//////////////////////////////////////////////////////
// These response methods actually change both
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetGrid(VDKObject*)
{
  SetPropValue(HAVEGRID, gridcb->Checked ? CHECK_TRUE : CHECK_FALSE);
  sprintf(buff,"%d",(int) vspace->ValueAsInt);
  SetPropValue(GRIDVSPACE,buff);
  sprintf(buff,"%d",(int) hspace->ValueAsInt);
  SetPropValue(GRIDHSPACE,buff);
  inspector->FormNeedToBeChanged();
  if(gridcb->Checked)
    fixed_draw_grid (Container(), (int) hspace->ValueAsInt,
		   (int) vspace->ValueAsInt, 1); // dots
  return true;
}

