#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str

  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkxpmbrowser.h>

DEFINE_SIGNAL_MAP(VDKXpmBrowser,VDKFileDialog)
  ON_SIGNAL(filelist,select_row_signal,OpenClick)
END_SIGNAL_MAP

VDKXpmBrowser::VDKXpmBrowser(VDKForm* owner,
		FileStringArray* selections,
		char* title, 
		GtkWindowType display):
	VDKFileDialog(owner,selections,title,display)
{
gtk_clist_set_selection_mode (GTK_CLIST(filelist->CustomWidget()),
						GTK_SELECTION_SINGLE);
VDKFrame* frame = new VDKFrame(this,_("Preview"),h_box, shadow_in);
pixmap = new VDKPixmap(this,(char*) NULL);
pixmap->SetSize(-1,50);
frame->Add(pixmap);
Add(frame);
Filter = "*.xpm";
gtk_signal_connect( GTK_OBJECT(filelist->CustomWidget()),
			"select_row",
			GTK_SIGNAL_FUNC(VDKXpmBrowser::XpmSelected),  
			(gpointer) this);
}
/*
*/
void 
VDKXpmBrowser::XpmSelected(GtkWidget* , 
		  gint row,
		  gint column,
		  GdkEvent *event,
		  gpointer gp)
{
static char buff[256];
VDKXpmBrowser *browser = reinterpret_cast<VDKXpmBrowser*>(gp);
int j = browser->filelist->Selected.Row();
if(j >= 0)
	{
	sprintf(buff,"%s/%s",(char*) browser->pcwd,
		(char*) browser->filelist->Tuples[j][0]);
	browser->pixmap->SetPixmap(buff);
	}
}
/*
stops signal here
*/
bool 
VDKXpmBrowser::OpenClick(VDKObject*)
{
return true;
}
