
/*
 * config.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: config.h,v 1.1 2004/10/24 12:57:09 chelli-guest Exp $
 */


#ifndef __CON_CONFIG_H_
#define __CON_CONFIG_H_


#include <vdr/config.h>


struct sConsoleConfig {

  sConsoleConfig():
 
    TextColor( 6 ),
    BoldTextColor( 7 ),
    TextBackColor( -1 ),
    CompressText( false ),

    AutoEnterKeyboardMode( true ),

    BellTimeout( 5 )
  {}


  int TextColor;
  int BoldTextColor;
  int TextBackColor;
  int CompressText;

  int AutoEnterKeyboardMode;

  int BellTimeout;

};


extern sConsoleConfig config;



// Adapted from vdr

class cConsoleCommand : public cListObject {
private:
  char *title;
  char *command;
  bool confirm;
public:
  cConsoleCommand(void);
  virtual ~cConsoleCommand();
  bool Parse(const char *s);
  const char *Title(void) { return title; }
  bool Confirm(void) { return confirm; }
  const char *Command() { return command; }
  };


class cConsoleCommands : public cConfig<cConsoleCommand> {};

extern cConsoleCommands gl_ConsoleCommands;


#endif // __CON_CONFIG_H_
